/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;

public class EncryptedTokenSerializer {
    private static final JWSHeader HEADER = new JWSHeader(JWSAlgorithm.HS256);
    private static final JWEHeader JWE_HEADER = new JWEHeader.Builder(JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256).contentType("JWT").build();

    public static String serialize(JWTClaimsSet claimsSet, byte[] key) {
        try {
            MACSigner signer = new MACSigner(key);
            SignedJWT signedJWT = new SignedJWT(HEADER, claimsSet);
            signedJWT.sign((JWSSigner)signer);
            JWEObject jweObject = new JWEObject(JWE_HEADER, new Payload(signedJWT));
            jweObject.encrypt((JWEEncrypter)new DirectEncrypter(key));
            String jweString = jweObject.serialize();
            return jweString;
        }
        catch (JOSEException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JWTClaimsSet deserialize(String serializedToken, byte[] key) {
        try {
            JWEObject jweObject = JWEObject.parse((String)serializedToken);
            jweObject.decrypt((JWEDecrypter)new DirectDecrypter(key));
            SignedJWT signedJWT = jweObject.getPayload().toSignedJWT();
            signedJWT.verify((JWSVerifier)new MACVerifier(key));
            JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
            return jwtClaimsSet;
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        catch (JOSEException e) {
            throw new IllegalStateException(e);
        }
    }
}

