/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import java.util.Hashtable;

public abstract class UErrorCode {
    public static final int ER_NO_ERROR = 0;
    public static final int ER_NOT_OBJECT = 1;
    public static final int ER_DBMS = 2;
    public static final int ER_COMMUNICATION = 3;
    public static final int ER_NO_MORE_DATA = 4;
    public static final int ER_TYPE_CONVERSION = 5;
    public static final int ER_BIND_INDEX = 6;
    public static final int ER_NOT_BIND = 7;
    public static final int ER_WAS_NULL = 8;
    public static final int ER_COLUMN_INDEX = 9;
    public static final int ER_TRUNCATE = 10;
    public static final int ER_SCHEMA_TYPE = 11;
    public static final int ER_FILE = 12;
    public static final int ER_CONNECTION = 13;
    public static final int ER_ISO_TYPE = 14;
    public static final int ER_ILLEGAL_REQUEST = 15;
    public static final int ER_INVALID_ARGUMENT = 16;
    public static final int ER_IS_CLOSED = 17;
    public static final int ER_ILLEGAL_FLAG = 18;
    public static final int ER_ILLEGAL_DATA_SIZE = 19;
    public static final int ER_NO_MORE_RESULT = 20;
    public static final int ER_OID_IS_NOT_INCLUDED = 21;
    public static final int ER_CMD_IS_NOT_INSERT = 22;
    public static final int ER_UNKNOWN = 23;
    public static final int ER_TIMEOUT = 24;
    public static final int CAS_ER_DBMS = -1000;
    public static final int CAS_ER_INTERNAL = -1001;
    public static final int CAS_ER_NO_MORE_MEMORY = -1002;
    public static final int CAS_ER_COMMUNICATION = -1003;
    public static final int CAS_ER_ARGS = -1004;
    public static final int CAS_ER_TRAN_TYPE = -1005;
    public static final int CAS_ER_SRV_HANDLE = -1006;
    public static final int CAS_ER_NUM_BIND = -1007;
    public static final int CAS_ER_UNKNOWN_U_TYPE = -1008;
    public static final int CAS_ER_DB_VALUE = -1009;
    public static final int CAS_ER_TYPE_CONVERSION = -1010;
    public static final int CAS_ER_PARAM_NAME = -1011;
    public static final int CAS_ER_NO_MORE_DATA = -1012;
    public static final int CAS_ER_OBJECT = -1013;
    public static final int CAS_ER_OPEN_FILE = -1014;
    public static final int CAS_ER_SCHEMA_TYPE = -1015;
    public static final int CAS_ER_VERSION = -1016;
    public static final int CAS_ER_FREE_SERVER = -1017;
    public static final int CAS_ER_NOT_AUTHORIZED_CLIENT = -1018;
    public static final int CAS_ER_QUERY_CANCEL = -1019;
    public static final int CAS_ER_NOT_COLLECTION = -1020;
    public static final int CAS_ER_COLLECTION_DOMAIN = -1021;
    public static final int CAS_ER_NO_MORE_RESULT_SET = -1022;
    public static final int CAS_ER_INVALID_CALL_STMT = -1023;
    public static final int CAS_ER_STMT_POOLING = -1024;
    public static final int CAS_ER_DBSERVER_DISCONNECTED = -1025;
    public static final int CAS_ER_MAX_PREPARED_STMT_COUNT_EXCEEDED = -1026;
    public static final int CAS_ER_NOT_IMPLEMENTED = -1100;
    public static final int CAS_ER_IS = -1200;
    public static final int CAS_ERROR_INDICATOR = -1;
    public static final int DBMS_ERROR_INDICATOR = -2;
    private static Hashtable<Integer, String> messageString;
    private static Hashtable<Integer, String> CASMessageString;

    public static String codeToMessage(int n) {
        if (messageString == null) {
            UErrorCode.setMessageHash();
        }
        return messageString.get(new Integer(n));
    }

    public static String codeToCASMessage(int n) {
        if (CASMessageString == null) {
            UErrorCode.setCASMessageHash();
        }
        return CASMessageString.get(new Integer(n));
    }

    private static void setMessageHash() {
        messageString = new Hashtable();
        messageString.put(new Integer(23), "Error");
        messageString.put(new Integer(0), "No Error");
        messageString.put(new Integer(2), "Server error");
        messageString.put(new Integer(3), "Cannot communicate with the broker");
        messageString.put(new Integer(4), "Invalid cursor position");
        messageString.put(new Integer(5), "Type conversion error");
        messageString.put(new Integer(6), "Missing or invalid position of the bind variable provided");
        messageString.put(new Integer(7), "Attempt to execute the query when not all the parameters are binded");
        messageString.put(new Integer(8), "Internal Error: NULL value");
        messageString.put(new Integer(9), "Column index is out of range");
        messageString.put(new Integer(10), "Data is truncated because receive buffer is too small");
        messageString.put(new Integer(11), "Internal error: Illegal schema type");
        messageString.put(new Integer(12), "File access failed");
        messageString.put(new Integer(13), "Cannot connect to a broker");
        messageString.put(new Integer(14), "Unknown transaction isolation level");
        messageString.put(new Integer(15), "Internal error: The requested information is not available");
        messageString.put(new Integer(16), "The argument is invalid");
        messageString.put(new Integer(17), "Connection or Statement might be closed");
        messageString.put(new Integer(18), "Internal error: Invalid argument");
        messageString.put(new Integer(19), "Cannot communicate with the broker or received invalid packet");
        messageString.put(new Integer(1), "Index's Column is Not Object");
        messageString.put(new Integer(20), "No More Result");
        messageString.put(new Integer(21), "This ResultSet do not include the OID");
        messageString.put(new Integer(22), "Command is not insert");
        messageString.put(new Integer(24), "Request timed out");
    }

    private static void setCASMessageHash() {
        CASMessageString = new Hashtable();
        CASMessageString.put(new Integer(-1000), "Database connection error");
        CASMessageString.put(new Integer(-1001), "General server error");
        CASMessageString.put(new Integer(-1002), "Memory allocation error");
        CASMessageString.put(new Integer(-1003), "Communication error");
        CASMessageString.put(new Integer(-1004), "Invalid argument");
        CASMessageString.put(new Integer(-1005), "Unknown transaction type");
        CASMessageString.put(new Integer(-1006), "Internal server error");
        CASMessageString.put(new Integer(-1007), "Parameter binding error");
        CASMessageString.put(new Integer(-1008), "Parameter binding error");
        CASMessageString.put(new Integer(-1009), "Cannot make DB_VALUE");
        CASMessageString.put(new Integer(-1010), "Type conversion error");
        CASMessageString.put(new Integer(-1011), "Invalid database parameter name");
        CASMessageString.put(new Integer(-1012), "No more data");
        CASMessageString.put(new Integer(-1013), "Object is not valid");
        CASMessageString.put(new Integer(-1014), "File open error");
        CASMessageString.put(new Integer(-1015), "Invalid schema type");
        CASMessageString.put(new Integer(-1016), "Version mismatch");
        CASMessageString.put(new Integer(-1017), "Cannot process the request. Try again later");
        CASMessageString.put(new Integer(-1018), "Authorization error");
        CASMessageString.put(new Integer(-1019), "Cannot cancel the query");
        CASMessageString.put(new Integer(-1020), "The attribute domain must be the set type");
        CASMessageString.put(new Integer(-1021), "The domain of a set must be the same data type");
        CASMessageString.put(new Integer(-1022), "No More Result");
        CASMessageString.put(new Integer(-1023), "Illegal CALL statement");
        CASMessageString.put(new Integer(-1024), "Statement Pooling");
        CASMessageString.put(new Integer(-1025), "DB Server disconnected");
        CASMessageString.put(new Integer(-1026), "Cannot prepare more than MAX_PREPARED_STMT_COUNT statements");
        CASMessageString.put(new Integer(-1100), "Attempt to use a not supported service");
        CASMessageString.put(new Integer(-1200), "Authentication failure");
    }
}

