/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDJdbcInfoTable;
import cubrid.jdbc.driver.CUBRIDXid;
import cubrid.jdbc.driver.ConnectionProperties;
import cubrid.jdbc.jci.UAParameter;
import cubrid.jdbc.jci.UBatchResult;
import cubrid.jdbc.jci.UBindParameter;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UInputBuffer;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJCIUtil;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UOutputBuffer;
import cubrid.jdbc.jci.UPutByOIDParameter;
import cubrid.jdbc.jci.UStatement;
import cubrid.jdbc.jci.UTimedDataInputStream;
import cubrid.jdbc.jci.UUrlCache;
import cubrid.jdbc.jci.UUrlHostKey;
import cubrid.jdbc.log.BasicLogger;
import cubrid.jdbc.log.Log;
import cubrid.jdbc.net.BrokerHandler;
import cubrid.sql.CUBRIDOID;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UConnection {
    public static final byte DBMS_CUBRID = 1;
    public static final byte PREPARE_INCLUDE_OID = 1;
    public static final byte PREPARE_UPDATABLE = 2;
    public static final byte PREPARE_QUERY_INFO = 4;
    public static final byte PREPARE_CALL = 64;
    public static final byte DROP_BY_OID = 1;
    public static final byte IS_INSTANCE = 2;
    public static final byte GET_READ_LOCK_BY_OID = 3;
    public static final byte GET_WRITE_LOCK_BY_OID = 4;
    public static final byte GET_CLASS_NAME_BY_OID = 5;
    public static final int OID_BYTE_SIZE = 8;
    private static final String magicString = "CUBRK";
    private static final byte CAS_CLIENT_JDBC = 3;
    private static final byte CAS_PROTOCOL_VERSION = 1;
    private static final byte CAS_PROTO_INDICATOR = 64;
    private static final byte CAS_PROTO_VER_MASK = 63;
    private static final byte GET_COLLECTION_VALUE = 1;
    private static final byte GET_SIZE_OF_COLLECTION = 2;
    private static final byte DROP_ELEMENT_IN_SET = 3;
    private static final byte ADD_ELEMENT_TO_SET = 4;
    private static final byte DROP_ELEMENT_IN_SEQUENCE = 5;
    private static final byte INSERT_ELEMENT_INTO_SEQUENCE = 6;
    private static final byte PUT_ELEMENT_ON_SEQUENCE = 7;
    private static final int DB_PARAM_ISOLATION_LEVEL = 1;
    private static final int DB_PARAM_LOCK_TIMEOUT = 2;
    private static final int DB_PARAM_AUTO_COMMIT = 4;
    private static final byte END_TRAN_COMMIT = 1;
    private static final byte END_TRAN_ROLLBACK = 2;
    private static final int LOCK_TIMEOUT_NOT_USED = -2;
    private static final int LOCK_TIMEOUT_INFINITE = -1;
    private static final int SOCKET_TIMEOUT = 5000;
    private static final byte CAS_INFO_STATUS_INACTIVE = 0;
    private static final byte CAS_INFO_STATUS_ACTIVE = 1;
    private static final int CAS_INFO_SIZE = 4;
    private static final int CAS_INFO_STATUS = 0;
    private static final int CAS_INFO_RESERVED_1 = 1;
    private static final int CAS_INFO_RESERVED_2 = 2;
    private static final int CAS_INFO_RESERVED_3 = 3;
    private static final int BROKER_INFO_SIZE = 8;
    private static final int BROKER_INFO_DBMS_TYPE = 0;
    private static final int BROKER_INFO_KEEP_CONNECTION = 1;
    private static final int BROKER_INFO_STATEMENT_POOLING = 2;
    private static final int BROKER_INFO_CCI_PCONNECT = 3;
    private static final int BROKER_INFO_PROTO_VERSION = 4;
    private static final int BROKER_INFO_RESERVED1 = 5;
    private static final int BROKER_INFO_RESERVED2 = 6;
    private static final int BROKER_INFO_MAJOR_VERSION = 4;
    private static final int BROKER_INFO_MINOR_VERSION = 5;
    private static final int BROKER_INFO_PATCH_VERSION = 6;
    public static final String ZERO_DATETIME_BEHAVIOR_CONVERT_TO_NULL = "convertToNull";
    public static final String ZERO_DATETIME_BEHAVIOR_EXCEPTION = "exception";
    public static final String ZERO_DATETIME_BEHAVIOR_ROUND = "round";
    UOutputBuffer outBuffer;
    CUBRIDConnection cubridcon;
    boolean update_executed;
    private boolean needReconnection;
    private UTimedDataInputStream input;
    private DataOutputStream output;
    private String CASIp;
    private int CASPort;
    private int processId;
    private Socket client;
    private UError errorHandler;
    private Vector<UStatement> transactionList;
    private boolean isClosed = false;
    private byte[] dbInfo;
    private int lastIsolationLevel;
    private int lastLockTimeout = -2;
    private boolean lastAutoCommit = true;
    private String dbname;
    private String user;
    private String passwd;
    private String url;
    private ArrayList<String> altHosts = null;
    private int connectedHostId = 0;
    private byte[] broker_info = null;
    private byte[] casinfo = null;
    private int brokerVersion = 0;
    private boolean isServerSideJdbc = false;
    private byte[] checkCasMsg = null;
    boolean skip_checkcas;
    boolean need_checkcas;
    Vector<UStatement> pooled_ustmts;
    Vector<Integer> deferred_close_handle;
    Object curThread;
    private UUrlCache url_cache = null;
    private boolean isAutoCommitBySelf = false;
    public static byte[] driverInfo = new byte[10];
    private ConnectionProperties connectionProperties = new ConnectionProperties();
    private long lastRCTime = 0L;
    private int sessionId = 0;
    private Log log;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    UConnection(String string, int n, String string2, String string3, String string4, String string5) throws CUBRIDException {
        this.CASIp = string;
        this.CASPort = n;
        this.dbname = string2;
        this.user = string3;
        this.passwd = string4;
        this.url = string5;
        this.update_executed = false;
        this.needReconnection = true;
        this.errorHandler = new UError();
    }

    UConnection(ArrayList<String> arrayList, String string, String string2, String string3, String string4) throws CUBRIDException {
        this.setAltHosts(arrayList);
        this.dbname = string;
        this.user = string2;
        this.passwd = string3;
        this.url = string4;
        this.update_executed = false;
        this.needReconnection = true;
        this.errorHandler = new UError();
    }

    UConnection(Socket socket, Object object) throws CUBRIDException {
        this.errorHandler = new UError();
        try {
            this.client = socket;
            this.client.setTcpNoDelay(true);
            this.output = new DataOutputStream(this.client.getOutputStream());
            this.output.writeInt(8);
            this.output.flush();
            this.input = new UTimedDataInputStream(this.client.getInputStream(), this.CASIp, this.CASPort);
            this.needReconnection = false;
            this.casinfo = new byte[4];
            this.casinfo[0] = 1;
            this.isServerSideJdbc = true;
            this.lastAutoCommit = false;
            this.curThread = object;
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setCharSet", new Class[]{String.class}, this.curThread, new Object[]{this.connectionProperties.getCharSet()});
        }
        catch (IOException iOException) {
            UJciException uJciException = new UJciException(13);
            uJciException.toUError(this.errorHandler);
            throw new CUBRIDException(this.errorHandler, (Throwable)iOException);
        }
    }

    public void tryConnect() throws CUBRIDException {
        try {
            this.checkReconnect();
            this.endTransaction(true);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            throw new CUBRIDException(this.errorHandler, (Throwable)uJciException);
        }
        catch (IOException iOException) {
            if (iOException instanceof SocketTimeoutException) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.request_timeout, (Throwable)iOException);
            }
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, (Throwable)iOException);
        }
    }

    public void setAltHosts(ArrayList<String> arrayList) throws CUBRIDException {
        if (arrayList.size() < 1) {
            throw new CUBRIDException(16);
        }
        this.altHosts = arrayList;
        String string = this.altHosts.get(0);
        int n = string.indexOf(58);
        this.CASIp = n < 0 ? string.substring(0) : string.substring(0, n);
        this.CASPort = n > 0 ? Integer.valueOf(string.substring(n + 1)) : 30000;
    }

    public int getQueryTimeout() {
        return this.connectionProperties.getQueryTimeout();
    }

    public void setCharset(String string) {
        if (UJCIUtil.isServerSide() && this.isServerSideJdbc) {
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setCharSet", new Class[]{String.class}, this.curThread, new Object[]{string});
        }
    }

    public String getCharset() {
        return this.connectionProperties.getCharSet();
    }

    public void setZeroDateTimeBehavior(String string) throws CUBRIDException {
        if (UJCIUtil.isServerSide() && this.isServerSideJdbc) {
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setZeroDateTimeBehavior", new Class[]{String.class}, this.curThread, new Object[]{string});
        }
    }

    public String getZeroDateTimeBehavior() {
        return this.connectionProperties.getZeroDateTimeBehavior();
    }

    public boolean getLogSlowQuery() {
        return this.connectionProperties.getLogSlowQueris();
    }

    public synchronized void addElementToSet(CUBRIDOID cUBRIDOID, String string, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSet(cUBRIDOID, string, object, (byte)4);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
            return;
        }
    }

    public synchronized UBatchResult batchExecute(String[] stringArray) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (stringArray == null) {
            this.errorHandler.setErrorCode(16);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)20);
            this.outBuffer.addByte(this.getAutoCommit() ? (byte)1 : 0);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) {
                    this.outBuffer.addStringWithNull(stringArray[i]);
                    continue;
                }
                this.outBuffer.addNull();
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            UBatchResult uBatchResult = new UBatchResult(uInputBuffer.readInt());
            for (int i = 0; i < uBatchResult.getResultNumber(); ++i) {
                uBatchResult.setStatementType(i, uInputBuffer.readByte());
                int n = uInputBuffer.readInt();
                if (n < 0) {
                    uBatchResult.setResultError(i, n, uInputBuffer.readString(uInputBuffer.readInt(), UJCIManager.sysCharsetName));
                    continue;
                }
                uBatchResult.setResult(i, n);
                uInputBuffer.readInt();
                uInputBuffer.readShort();
                uInputBuffer.readShort();
            }
            this.transactionList.add(null);
            this.update_executed = true;
            return uBatchResult;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return null;
    }

    public synchronized void close() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        this.clearTransactionList();
        this.transactionList = null;
        if (this.client != null) {
            this.disconnect();
        }
        if (!this.isServerSideJdbc) {
            try {
                if (this.client != null) {
                    this.clientSocketClose();
                }
            }
            catch (IOException iOException) {
                this.errorHandler.setErrorMessage(3, iOException.getMessage() + "in close");
            }
        }
        this.isClosed = true;
    }

    public synchronized void dropElementInSequence(CUBRIDOID cUBRIDOID, String string, int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)18);
            this.outBuffer.addByte((byte)5);
            this.outBuffer.addOID(cUBRIDOID);
            this.outBuffer.addInt(n);
            if (string == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string);
            }
            this.send_recv_msg();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized void dropElementInSet(CUBRIDOID cUBRIDOID, String string, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSet(cUBRIDOID, string, object, (byte)3);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
            return;
        }
    }

    public synchronized void endTransaction(boolean bl) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.needReconnection) {
            return;
        }
        try {
            this.clearTransactionList();
            if (this.client != null && this.getCASInfoStatus() != 0) {
                this.checkReconnect();
                if (this.errorHandler.getErrorCode() != 0) {
                    return;
                }
                if (this.getCASInfoStatus() == 1) {
                    if (UJCIUtil.isConsoleDebug() && this.lastAutoCommit && !this.isAutoCommitBySelf && bl) {
                        throw new Exception("Check It Out!");
                    }
                    this.outBuffer.newRequest(this.output, (byte)1);
                    this.outBuffer.addByte(bl ? (byte)1 : 2);
                    this.send_recv_msg();
                    if (this.lastAutoCommit) {
                        this.turnOffAutoCommitBySelf();
                    }
                }
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        catch (Exception exception) {
            this.errorHandler.setErrorMessage(23, exception.getMessage());
        }
        boolean bl2 = this.brokerInfoKeepConnection();
        long l = System.currentTimeMillis() / 1000L;
        int n = this.connectionProperties.getReconnectTime();
        if (this.connectedHostId > 0 && this.lastRCTime != 0L && n > 0 && l - this.lastRCTime > (long)n) {
            bl2 = false;
            this.lastRCTime = l;
        }
        if (this.errorHandler.getErrorCode() != 0 || !bl2) {
            if (!bl) {
                this.errorHandler.clear();
            }
            try {
                this.clientSocketClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.needReconnection = true;
        }
        this.casinfo[0] = 0;
        this.update_executed = false;
    }

    public synchronized OutputStream getOutputStream() {
        return this.output;
    }

    public synchronized UStatement getByOID(CUBRIDOID cUBRIDOID, String[] stringArray) {
        UStatement uStatement = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)10);
            this.outBuffer.addOID(cUBRIDOID);
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (stringArray[i] != null) {
                    this.outBuffer.addStringWithNull(stringArray[i]);
                    continue;
                }
                this.outBuffer.addNull();
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            uStatement = new UStatement(this, cUBRIDOID, stringArray, uInputBuffer);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
            return null;
        }
        if (uStatement.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(uStatement.getRecentError());
            return null;
        }
        this.transactionList.add(uStatement);
        return uStatement;
    }

    public synchronized String getDatabaseProductVersion() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)15);
            this.outBuffer.addByte(this.getAutoCommit() ? (byte)1 : 0);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            return uInputBuffer.readString(uInputBuffer.remainedCapacity(), UJCIManager.sysCharsetName);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return null;
    }

    public synchronized int getIsolationLevel() {
        this.errorHandler = new UError();
        if (UJCIUtil.isMMDB()) {
            return 1;
        }
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return 0;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.output, (byte)4);
            this.outBuffer.addInt(1);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            return uInputBuffer.readInt();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return 0;
    }

    public UError getRecentError() {
        return this.errorHandler;
    }

    public synchronized String getQueryplanOnly(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            this.outBuffer.newRequest((byte)24);
            this.outBuffer.addInt(0);
            this.outBuffer.addByte((byte)1);
            this.outBuffer.addStringWithNull(string);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            string2 = uInputBuffer.readString(uInputBuffer.remainedCapacity(), this.connectionProperties.getCharSet());
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return null;
        }
        if (this.errorHandler.getErrorCode() != 0) {
            return null;
        }
        return string2;
    }

    public synchronized UStatement getSchemaInfo(int n, String string, String string2, byte by) {
        UStatement uStatement = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (n < 1 || n > 19) {
            this.errorHandler.setErrorCode(11);
            return null;
        }
        if (by < 0 || by > 3) {
            this.errorHandler.setErrorCode(18);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)9);
            this.outBuffer.addInt(n);
            if (string == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string);
            }
            if (string2 == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string2);
            }
            this.outBuffer.addByte(by);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            uStatement = new UStatement(this, string, string2, n, uInputBuffer);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return null;
        }
        if (uStatement.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(uStatement.getRecentError());
            return null;
        }
        return uStatement;
    }

    public synchronized int getSizeOfCollection(CUBRIDOID cUBRIDOID, String string) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return 0;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.output, (byte)18);
            this.outBuffer.addByte((byte)2);
            this.outBuffer.addOID(cUBRIDOID);
            if (string == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string);
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            return uInputBuffer.readInt();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return 0;
    }

    public synchronized void insertElementIntoSequence(CUBRIDOID cUBRIDOID, String string, int n, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSequence(cUBRIDOID, string, n, object, (byte)6);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized UStatement prepare(String string, byte by) {
        return this.prepare(string, by, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UStatement prepare(String string, byte by, boolean bl) {
        UStatement uStatement = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            Object object;
            this.skip_checkcas = true;
            this.need_checkcas = false;
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                UStatement uStatement2 = null;
                return uStatement2;
            }
            this.outBuffer.newRequest(this.output, (byte)2);
            this.outBuffer.addStringWithNull(string);
            this.outBuffer.addByte(by);
            this.outBuffer.addByte(this.getAutoCommit() ? (byte)1 : 0);
            while (!this.deferred_close_handle.isEmpty()) {
                object = this.deferred_close_handle.remove(0);
                this.outBuffer.addInt((Integer)object);
            }
            object = this.send_recv_msg();
            uStatement = bl ? new UStatement(this, (UInputBuffer)object, true, string, by) : new UStatement(this, (UInputBuffer)object, false, string, by);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
        }
        finally {
            this.skip_checkcas = false;
        }
        if (this.errorHandler.getErrorCode() != 0) {
            if (this.errorHandler.getJdbcErrorCode() == -111) {
                this.need_checkcas = true;
            }
            if (this.need_checkcas) {
                if (!this.check_cas()) {
                    try {
                        this.clientSocketClose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this.prepare(string, by, bl);
            }
            return null;
        }
        if (uStatement.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(uStatement.getRecentError());
            return null;
        }
        this.transactionList.add(uStatement);
        this.pooled_ustmts.add(uStatement);
        return uStatement;
    }

    public synchronized void putByOID(CUBRIDOID cUBRIDOID, String[] stringArray, Object[] objectArray) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (stringArray == null && objectArray == null) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        try {
            UPutByOIDParameter uPutByOIDParameter = null;
            if (objectArray != null) {
                uPutByOIDParameter = new UPutByOIDParameter(stringArray, objectArray);
            }
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)11);
            this.outBuffer.addOID(cUBRIDOID);
            if (uPutByOIDParameter != null) {
                uPutByOIDParameter.writeParameter(this.outBuffer);
            }
            this.send_recv_msg();
            if (this.getAutoCommit()) {
                this.turnOnAutoCommitBySelf();
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized void putElementInSequence(CUBRIDOID cUBRIDOID, String string, int n, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSequence(cUBRIDOID, string, n, object, (byte)7);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return;
        }
    }

    public synchronized void setIsolationLevel(int n) {
        this.errorHandler = new UError();
        if (!UJCIUtil.isMMDB()) {
            if (this.isClosed) {
                this.errorHandler.setErrorCode(17);
                return;
            }
            if (n < 1 || n > 6) {
                this.errorHandler.setErrorCode(14);
                return;
            }
            try {
                this.checkReconnect();
                if (this.errorHandler.getErrorCode() != 0) {
                    return;
                }
                this.outBuffer.newRequest(this.output, (byte)5);
                this.outBuffer.addInt(1);
                this.outBuffer.addInt(n);
                this.send_recv_msg();
                this.lastIsolationLevel = n;
            }
            catch (UJciException uJciException) {
                uJciException.toUError(this.errorHandler);
            }
            catch (IOException iOException) {
                this.errorHandler.setErrorCode(3);
            }
        }
    }

    public synchronized void setLockTimeout(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)5);
            this.outBuffer.addInt(2);
            this.outBuffer.addInt(n);
            this.send_recv_msg();
            this.lastLockTimeout = n < 0 ? -1 : n;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public byte getCASInfoStatus() {
        if (this.casinfo == null) {
            return 0;
        }
        return this.casinfo[0];
    }

    public byte[] getCASInfo() {
        return this.casinfo;
    }

    public void setCASInfo(byte[] byArray) {
        this.casinfo = byArray;
    }

    public byte getDbmsType() {
        if (this.broker_info == null) {
            return 1;
        }
        return this.broker_info[0];
    }

    public boolean isConnectedToCubrid() {
        return this.getDbmsType() == 1;
    }

    public boolean brokerInfoStatementPooling() {
        if (this.broker_info == null) {
            return false;
        }
        return this.broker_info[2] == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void xa_endTransaction(Xid xid, boolean bl) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.clearTransactionList();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)30);
            this.outBuffer.addXid(xid);
            this.outBuffer.addByte(bl ? (byte)1 : 2);
            this.send_recv_msg();
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
        }
        finally {
            try {
                this.clientSocketClose();
                this.needReconnection = true;
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void xa_prepare(Xid xid) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)28);
            this.outBuffer.addXid(xid);
            this.send_recv_msg();
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
        }
    }

    public synchronized Xid[] xa_recover() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)29);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n = uInputBuffer.getResCode();
            Xid[] xidArray = new CUBRIDXid[n];
            for (int i = 0; i < n; ++i) {
                xidArray[i] = uInputBuffer.readXid();
            }
            return xidArray;
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
            return null;
        }
    }

    public void setCUBRIDConnection(CUBRIDConnection cUBRIDConnection) {
        this.cubridcon = cUBRIDConnection;
        this.lastIsolationLevel = 0;
        this.lastLockTimeout = -2;
    }

    public CUBRIDConnection getCUBRIDConnection() {
        return this.cubridcon;
    }

    private static void printCasInfo(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            String string = "[PREV : %d, RECV : %d], [preffunc : %d, recvfunc : %d], [REQ: %d], [JID: %d]";
            String string2 = String.format(string, byArray[0], byArray2[0], byArray[1], byArray2[1], byArray[2], byArray2[3]);
            CUBRIDDriver.printDebug(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean check_cas() {
        if (this.isClosed) {
            return true;
        }
        if (this.client == null || this.needReconnection) {
            return true;
        }
        if (this.skip_checkcas) {
            this.need_checkcas = true;
            return true;
        }
        try {
            UTimedDataInputStream uTimedDataInputStream = this.input;
            synchronized (uTimedDataInputStream) {
                if (this.checkCasMsg == null) {
                    int n = 1;
                    this.checkCasMsg = new byte[9];
                    this.checkCasMsg[0] = (byte)(n >>> 24 & 0xFF);
                    this.checkCasMsg[1] = (byte)(n >>> 16 & 0xFF);
                    this.checkCasMsg[2] = (byte)(n >>> 8 & 0xFF);
                    this.checkCasMsg[3] = (byte)(n >>> 0 & 0xFF);
                    this.checkCasMsg[4] = this.casinfo[0];
                    this.checkCasMsg[5] = this.casinfo[1];
                    this.checkCasMsg[6] = this.casinfo[2];
                    this.checkCasMsg[7] = this.casinfo[3];
                    this.checkCasMsg[8] = 32;
                } else {
                    this.checkCasMsg[4] = this.casinfo[0];
                    this.checkCasMsg[5] = this.casinfo[1];
                    this.checkCasMsg[6] = this.casinfo[2];
                    this.checkCasMsg[7] = this.casinfo[3];
                }
                byte[] byArray = this.casinfo;
                this.output.write(this.checkCasMsg);
                int n = this.input.readInt();
                byte[] byArray2 = new byte[4];
                this.input.readByte(byArray2);
                this.casinfo = byArray2;
                if (UJCIUtil.isConsoleDebug()) {
                    UConnection.printCasInfo(byArray, this.casinfo);
                }
                if (n == 0) {
                    return true;
                }
                if (n < 4) {
                    return false;
                }
                n = this.input.readInt();
                if (n < 0) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public synchronized boolean check_cas(String string) {
        try {
            this.outBuffer.newRequest(this.output, (byte)32);
            this.outBuffer.addStringWithNull(string);
            this.send_recv_msg();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public synchronized void reset_connection() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client = null;
        this.needReconnection = true;
    }

    public synchronized Object oidCmd(CUBRIDOID cUBRIDOID, byte by) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)17);
            this.outBuffer.addByte(by);
            this.outBuffer.addOID(cUBRIDOID);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n = uInputBuffer.getResCode();
            if (by == 2) {
                if (n == 1) {
                    return cUBRIDOID;
                }
            } else if (by == 5) {
                return uInputBuffer.readString(uInputBuffer.remainedCapacity(), this.connectionProperties.getCharSet());
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return null;
    }

    public synchronized byte[] lobNew(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)35);
            this.outBuffer.addInt(n);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n2 = uInputBuffer.getResCode();
            if (n2 < 0) {
                this.errorHandler.setErrorCode(23);
                return null;
            }
            byte[] byArray = new byte[n2];
            uInputBuffer.readBytes(byArray);
            return byArray;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
        }
        return null;
    }

    public synchronized int lobWrite(byte[] byArray, long l, byte[] byArray2, int n, int n2) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return -1;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return -1;
            }
            this.outBuffer.newRequest(this.output, (byte)36);
            this.outBuffer.addBytes(byArray);
            this.outBuffer.addLong(l);
            this.outBuffer.addBytes(byArray2, n, n2);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n3 = uInputBuffer.getResCode();
            if (n3 < 0) {
                this.errorHandler.setErrorCode(23);
            }
            return n3;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
        }
        return -1;
    }

    public synchronized int lobRead(byte[] byArray, long l, byte[] byArray2, int n, int n2) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return -1;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return -1;
            }
            this.outBuffer.newRequest(this.output, (byte)37);
            this.outBuffer.addBytes(byArray);
            this.outBuffer.addLong(l);
            this.outBuffer.addInt(n2);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n3 = uInputBuffer.getResCode();
            if (n3 < 0) {
                this.errorHandler.setErrorCode(23);
            } else {
                uInputBuffer.readBytes(byArray2, n, n3);
            }
            return n3;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
        }
        return -1;
    }

    public synchronized void setAutoCommit(boolean bl) {
        if (!this.isServerSideJdbc && this.lastAutoCommit != bl) {
            this.lastAutoCommit = bl;
        }
    }

    public boolean getAutoCommit() {
        return this.lastAutoCommit;
    }

    public int currentIsolationLevel() {
        return this.lastIsolationLevel;
    }

    void clientSocketClose() throws IOException {
        try {
            this.needReconnection = true;
            if (this.client != null) {
                this.client.setSoLinger(true, 0);
                this.client.close();
            }
            this.client = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.clearPooledUStatements();
        this.deferred_close_handle.clear();
    }

    UInputBuffer send_recv_msg(boolean bl) throws UJciException, IOException {
        byte[] byArray = this.casinfo;
        this.outBuffer.sendData();
        UInputBuffer uInputBuffer = new UInputBuffer(this.input, this);
        if (UJCIUtil.isConsoleDebug()) {
            UConnection.printCasInfo(byArray, this.casinfo);
        }
        return uInputBuffer;
    }

    UInputBuffer send_recv_msg() throws UJciException, IOException {
        return this.send_recv_msg(true);
    }

    void cancel() throws UJciException, IOException {
        BrokerHandler.cancelBroker(this.CASIp, this.CASPort, this.processId, 0);
    }

    UUrlCache getUrlCache() {
        if (this.url_cache == null) {
            UUrlHostKey uUrlHostKey = new UUrlHostKey(this.CASIp, this.CASPort, this.dbname, this.user);
            this.url_cache = UJCIManager.getUrlCache(uUrlHostKey);
        }
        return this.url_cache;
    }

    private void reconnectWorker() throws IOException, UJciException {
        if (UJCIUtil.isConsoleDebug()) {
            CUBRIDDriver.printDebug(String.format("Try Connect (%s,%d)", this.CASIp, this.CASPort));
        }
        long l = System.currentTimeMillis();
        int n = this.connectionProperties.getConnectTimeout() * 1000;
        this.client = BrokerHandler.connectBroker(this.CASIp, this.CASPort, n);
        this.output = new DataOutputStream(this.client.getOutputStream());
        this.input = new UTimedDataInputStream(this.client.getInputStream(), this.CASIp, this.CASPort);
        n = (int)((long)n - (System.currentTimeMillis() - l));
        this.connectDB(n);
        CUBRIDDriver.setLastConnectInfo(this.url, this.makeConnectInfo(this.CASIp, this.CASPort));
        this.client.setTcpNoDelay(true);
        this.client.setSoTimeout(5000);
        this.needReconnection = false;
        if (this.connectionProperties.getReconnectTime() > 0) {
            this.lastRCTime = System.currentTimeMillis() / 1000L;
        }
        if (this.lastIsolationLevel != 0) {
            this.setIsolationLevel(this.lastIsolationLevel);
        }
        if (this.lastLockTimeout != -2) {
            this.setLockTimeout(this.lastLockTimeout);
        }
    }

    private String makeConnectInfo(String string, int n) {
        return String.format("%s:%d", string, n);
    }

    private void connectDB(int n) throws IOException, UJciException {
        UTimedDataInputStream uTimedDataInputStream = new UTimedDataInputStream(this.client.getInputStream(), this.CASIp, this.CASPort, n);
        DataOutputStream dataOutputStream = new DataOutputStream(this.client.getOutputStream());
        dataOutputStream.write(this.dbInfo);
        int n2 = uTimedDataInputStream.readInt();
        this.casinfo = new byte[4];
        uTimedDataInputStream.readFully(this.casinfo);
        if (n2 < 0) {
            throw new UJciException(19);
        }
        int n3 = uTimedDataInputStream.readInt();
        if (n3 < 0) {
            int n4 = uTimedDataInputStream.readInt();
            byte[] byArray = new byte[n2 - 8];
            uTimedDataInputStream.readFully(byArray);
            throw new UJciException(2, n3, n4, new String(byArray));
        }
        this.processId = n3;
        if (this.broker_info == null) {
            this.broker_info = new byte[8];
        }
        uTimedDataInputStream.readFully(this.broker_info);
        this.sessionId = uTimedDataInputStream.readInt();
        byte by = this.broker_info[4];
        this.brokerVersion = (by & 0x40) == 64 ? this.makeProtoVersion(by & 0x3F) : this.makeBrokerVersion(this.broker_info[4], this.broker_info[5], this.broker_info[6]);
    }

    private boolean setActiveHost(int n) throws UJciException {
        if (n >= this.altHosts.size()) {
            return false;
        }
        String string = this.altHosts.get(n);
        this.setConnectInfo(string);
        return true;
    }

    private void reconnect() throws IOException, UJciException {
        String string = CUBRIDDriver.getLastConnectInfo(this.url);
        if (string != null) {
            this.setConnectInfo(string);
            try {
                this.reconnectWorker();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.altHosts != null) {
            for (int i = 0; i < this.altHosts.size(); ++i) {
                try {
                    this.setActiveHost(i);
                    this.reconnectWorker();
                    this.connectedHostId = i;
                    return;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (UJciException uJciException) {
                    int n = uJciException.getJciError();
                    if (n == 3 || n == 13) continue;
                    throw uJciException;
                }
            }
            throw this.createJciException(13);
        }
        this.reconnectWorker();
    }

    private boolean brokerInfoKeepConnection() {
        if (this.broker_info == null) {
            return false;
        }
        return this.broker_info[1] == 1;
    }

    private int makeBrokerVersion(int n, int n2, int n3) {
        int n4 = 0;
        if (n < 0 || n > 127 || n2 < 0 || n2 > 127 || n3 < 0 || n3 > 127) {
            return 0;
        }
        n4 = n << 24 | n2 << 16 | n3 << 8;
        return n4;
    }

    private int makeProtoVersion(int n) {
        return 0x40000000 | n;
    }

    public int brokerInfoVersion() {
        return this.brokerVersion;
    }

    public boolean protoVersionIsAbove(int n) {
        return this.isServerSideJdbc() || this.brokerInfoVersion() >= this.makeProtoVersion(n);
    }

    private void setConnectInfo(String string) throws UJciException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            throw this.createJciException(13);
        }
        this.CASIp = stringTokenizer.nextToken();
        this.CASPort = Integer.valueOf(stringTokenizer.nextToken());
    }

    private void manageElementOfSequence(CUBRIDOID cUBRIDOID, String string, int n, Object object, byte by) throws UJciException, IOException {
        UAParameter uAParameter = new UAParameter(string, object);
        this.checkReconnect();
        if (this.errorHandler.getErrorCode() != 0) {
            return;
        }
        this.outBuffer.newRequest(this.output, (byte)18);
        this.outBuffer.addByte(by);
        this.outBuffer.addOID(cUBRIDOID);
        this.outBuffer.addInt(n);
        uAParameter.writeParameter(this.outBuffer);
        this.send_recv_msg();
    }

    private void manageElementOfSet(CUBRIDOID cUBRIDOID, String string, Object object, byte by) throws UJciException, IOException {
        UAParameter uAParameter = new UAParameter(string, object);
        this.checkReconnect();
        if (this.errorHandler.getErrorCode() != 0) {
            return;
        }
        this.outBuffer.newRequest(this.output, (byte)18);
        this.outBuffer.addByte(by);
        this.outBuffer.addOID(cUBRIDOID);
        uAParameter.writeParameter(this.outBuffer);
        this.send_recv_msg();
    }

    void checkReconnect() throws IOException, UJciException {
        if (this.dbInfo == null) {
            this.dbInfo = new byte[628];
            UJCIUtil.copy_byte(this.dbInfo, 0, 32, this.dbname);
            UJCIUtil.copy_byte(this.dbInfo, 32, 32, this.user);
            UJCIUtil.copy_byte(this.dbInfo, 64, 32, this.passwd);
            UJCIUtil.copy_byte(this.dbInfo, 96, 512, this.url);
        }
        UJCIUtil.copy_byte(this.dbInfo, 608, 20, new Integer(this.sessionId).toString());
        if (this.outBuffer == null) {
            this.outBuffer = new UOutputBuffer(this);
        }
        if (this.transactionList == null) {
            this.transactionList = new Vector();
        }
        if (this.deferred_close_handle == null) {
            this.deferred_close_handle = new Vector();
        }
        if (this.pooled_ustmts == null) {
            this.pooled_ustmts = new Vector();
        }
        if (!this.isServerSideJdbc) {
            if (this.getCASInfoStatus() == 0 && !this.check_cas()) {
                this.clientSocketClose();
            }
            if (this.needReconnection) {
                this.reconnect();
                if (UJCIUtil.isSendAppInfo()) {
                    this.sendAppInfo();
                }
            }
        }
    }

    private void sendAppInfo() {
        String string = CUBRIDJdbcInfoTable.getValue();
        if (string == null) {
            return;
        }
        this.check_cas(string);
    }

    public void closeSession() {
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)38);
            this.send_recv_msg();
            this.sessionId = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disconnect() {
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)31);
            this.send_recv_msg();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearTransactionList() {
        if (this.transactionList == null) {
            return;
        }
        this.transactionList.clear();
    }

    private void clearPooledUStatements() {
        if (this.pooled_ustmts == null) {
            return;
        }
        while (!this.pooled_ustmts.isEmpty()) {
            UStatement uStatement = this.pooled_ustmts.remove(0);
            if (uStatement == null) continue;
            uStatement.close(false);
        }
    }

    public boolean isServerSideJdbc() {
        return this.isServerSideJdbc;
    }

    public void turnOnAutoCommitBySelf() {
        this.isAutoCommitBySelf = true;
    }

    public void turnOffAutoCommitBySelf() {
        this.isAutoCommitBySelf = false;
    }

    public void setConnectionProperties(ConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    private Log getLogger() {
        if (this.log == null) {
            this.log = new BasicLogger(this.connectionProperties.getLogFile());
        }
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UJciException createJciException(int n) {
        UJciException uJciException = new UJciException(n);
        if (this.connectionProperties == null || !this.connectionProperties.getLogOnException()) {
            return uJciException;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DUMP EXCEPTION\n");
        stringBuffer.append("[JCI EXCEPTION]");
        UConnection uConnection = this;
        synchronized (uConnection) {
            this.getLogger().logInfo(stringBuffer.toString(), uJciException);
        }
        return uJciException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UJciException createJciException(int n, int n2, int n3, String string) {
        UJciException uJciException = new UJciException(n, n2, n3, string);
        if (this.connectionProperties == null || !this.connectionProperties.getLogOnException()) {
            return uJciException;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DUMP EXCEPTION\n");
        stringBuffer.append("[JCI EXCEPTION]");
        UConnection uConnection = this;
        synchronized (uConnection) {
            this.getLogger().logInfo(stringBuffer.toString(), uJciException);
        }
        return uJciException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CUBRIDException logCUBRIDException(CUBRIDException cUBRIDException) {
        if (this.connectionProperties == null || !this.connectionProperties.getLogOnException()) {
            return cUBRIDException;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DUMP EXCEPTION\n");
        if (cUBRIDException instanceof CUBRIDException) {
            stringBuffer.append("[CUBRID EXCEPTION]");
        } else {
            stringBuffer.append("[EXCEPTION]");
        }
        UConnection uConnection = this;
        synchronized (uConnection) {
            this.getLogger().logInfo(stringBuffer.toString(), cUBRIDException);
        }
        return cUBRIDException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSlowQuery(long l, long l2, String string, UBindParameter uBindParameter) {
        if (this.connectionProperties == null || !this.connectionProperties.getLogSlowQueris()) {
            return;
        }
        long l3 = l2 - l;
        if ((long)this.connectionProperties.getSlowQueryThresholdMillis() > l3) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SLOW QUERY\n");
        stringBuffer.append(String.format("[TIME]\nSTART: %s, ELAPSED: %d\n", this.dateFormat.format(new Date(l)), l3));
        stringBuffer.append("[SQL]\n").append(string).append('\n');
        if (uBindParameter != null) {
            stringBuffer.append("[BIND]\n");
            for (int i = 0; i < uBindParameter.values.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(uBindParameter.values[i].toString());
            }
            stringBuffer.append('\n');
        }
        UConnection uConnection = this;
        synchronized (uConnection) {
            this.getLogger().logInfo(stringBuffer.toString());
        }
    }

    static {
        UJCIUtil.copy_byte(driverInfo, 0, 5, magicString);
        UConnection.driverInfo[5] = 3;
        UConnection.driverInfo[6] = 65;
        UConnection.driverInfo[8] = 0;
        UConnection.driverInfo[7] = 0;
    }
}

