/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bag;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import org.apache.commons.collections.AbstractTestObject;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.bag.HashBag;

public abstract class AbstractTestBag
extends AbstractTestObject {
    public AbstractTestBag(String testName) {
        super(testName);
    }

    public abstract Bag makeBag();

    public Object makeObject() {
        return this.makeBag();
    }

    public void testBagAdd() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        Assert.assertTrue((String)"Should contain 'A'", (boolean)bag.contains("A"));
        Assert.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"A"));
        bag.add((Object)"A");
        Assert.assertTrue((String)"Should contain 'A'", (boolean)bag.contains("A"));
        Assert.assertEquals((String)"Should have count of 2", (int)2, (int)bag.getCount((Object)"A"));
        bag.add((Object)"B");
        Assert.assertTrue((boolean)bag.contains("A"));
        Assert.assertTrue((boolean)bag.contains("B"));
    }

    public void testBagEqualsSelf() {
        Bag bag = this.makeBag();
        Assert.assertTrue((boolean)bag.equals(bag));
        bag.add((Object)"elt");
        Assert.assertTrue((boolean)bag.equals(bag));
        bag.add((Object)"elt");
        Assert.assertTrue((boolean)bag.equals(bag));
        bag.add((Object)"elt2");
        Assert.assertTrue((boolean)bag.equals(bag));
    }

    public void testRemove() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        Assert.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A");
        Assert.assertEquals((String)"Should have count of 0", (int)0, (int)bag.getCount((Object)"A"));
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        Assert.assertEquals((String)"Should have count of 4", (int)4, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A", 0);
        Assert.assertEquals((String)"Should have count of 4", (int)4, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A", 2);
        Assert.assertEquals((String)"Should have count of 2", (int)2, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A");
        Assert.assertEquals((String)"Should have count of 0", (int)0, (int)bag.getCount((Object)"A"));
    }

    public void testRemoveAll() {
        Bag bag = this.makeBag();
        bag.add((Object)"A", 2);
        Assert.assertEquals((String)"Should have count of 2", (int)2, (int)bag.getCount((Object)"A"));
        bag.add((Object)"B");
        bag.add((Object)"C");
        Assert.assertEquals((String)"Should have count of 4", (int)4, (int)bag.size());
        ArrayList<String> delete = new ArrayList<String>();
        delete.add("A");
        delete.add("B");
        bag.removeAll(delete);
        Assert.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"A"));
        Assert.assertEquals((String)"Should have count of 0", (int)0, (int)bag.getCount((Object)"B"));
        Assert.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"C"));
        Assert.assertEquals((String)"Should have count of 2", (int)2, (int)bag.size());
    }

    public void testContains() {
        Bag bag = this.makeBag();
        Assert.assertEquals((String)"Bag does not have at least 1 'A'", (boolean)false, (boolean)bag.contains("A"));
        Assert.assertEquals((String)"Bag does not have at least 1 'B'", (boolean)false, (boolean)bag.contains("B"));
        bag.add((Object)"A");
        Assert.assertEquals((String)"Bag has at least 1 'A'", (boolean)true, (boolean)bag.contains("A"));
        Assert.assertEquals((String)"Bag does not have at least 1 'B'", (boolean)false, (boolean)bag.contains("B"));
        bag.add((Object)"A");
        Assert.assertEquals((String)"Bag has at least 1 'A'", (boolean)true, (boolean)bag.contains("A"));
        Assert.assertEquals((String)"Bag does not have at least 1 'B'", (boolean)false, (boolean)bag.contains("B"));
        bag.add((Object)"B");
        Assert.assertEquals((String)"Bag has at least 1 'A'", (boolean)true, (boolean)bag.contains("A"));
        Assert.assertEquals((String)"Bag has at least 1 'B'", (boolean)true, (boolean)bag.contains("B"));
    }

    public void testContainsAll() {
        Bag bag = this.makeBag();
        ArrayList known = new ArrayList();
        ArrayList<String> known1A = new ArrayList<String>();
        known1A.add("A");
        ArrayList<String> known2A = new ArrayList<String>();
        known2A.add("A");
        known2A.add("A");
        ArrayList<String> known1B = new ArrayList<String>();
        known1B.add("B");
        ArrayList<String> known1A1B = new ArrayList<String>();
        known1A1B.add("A");
        known1A1B.add("B");
        Assert.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'A'", (boolean)false, (boolean)bag.containsAll(known1A));
        Assert.assertEquals((String)"Bag does not containsAll of 2 'A'", (boolean)false, (boolean)bag.containsAll(known2A));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"A");
        Assert.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        Assert.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        Assert.assertEquals((String)"Bag does not containsAll of 2 'A'", (boolean)false, (boolean)bag.containsAll(known2A));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"A");
        Assert.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        Assert.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        Assert.assertEquals((String)"Bag containsAll of 2 'A'", (boolean)true, (boolean)bag.containsAll(known2A));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"A");
        Assert.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        Assert.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        Assert.assertEquals((String)"Bag containsAll of 2 'A'", (boolean)true, (boolean)bag.containsAll(known2A));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        Assert.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"B");
        Assert.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        Assert.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        Assert.assertEquals((String)"Bag containsAll of 2 'A'", (boolean)true, (boolean)bag.containsAll(known2A));
        Assert.assertEquals((String)"Bag containsAll of 1 'B'", (boolean)true, (boolean)bag.containsAll(known1B));
        Assert.assertEquals((String)"Bag containsAll of 1 'A' 1 'B'", (boolean)true, (boolean)bag.containsAll(known1A1B));
    }

    public void testSize() {
        Bag bag = this.makeBag();
        Assert.assertEquals((String)"Should have 0 total items", (int)0, (int)bag.size());
        bag.add((Object)"A");
        Assert.assertEquals((String)"Should have 1 total items", (int)1, (int)bag.size());
        bag.add((Object)"A");
        Assert.assertEquals((String)"Should have 2 total items", (int)2, (int)bag.size());
        bag.add((Object)"A");
        Assert.assertEquals((String)"Should have 3 total items", (int)3, (int)bag.size());
        bag.add((Object)"B");
        Assert.assertEquals((String)"Should have 4 total items", (int)4, (int)bag.size());
        bag.add((Object)"B");
        Assert.assertEquals((String)"Should have 5 total items", (int)5, (int)bag.size());
        bag.remove((Object)"A", 2);
        Assert.assertEquals((String)"Should have 1 'A'", (int)1, (int)bag.getCount((Object)"A"));
        Assert.assertEquals((String)"Should have 3 total items", (int)3, (int)bag.size());
        bag.remove((Object)"B");
        Assert.assertEquals((String)"Should have 1 total item", (int)1, (int)bag.size());
    }

    public void testRetainAll() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        ArrayList<String> retains = new ArrayList<String>();
        retains.add("B");
        retains.add("C");
        bag.retainAll(retains);
        Assert.assertEquals((String)"Should have 2 total items", (int)2, (int)bag.size());
    }

    public void testIterator() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Assert.assertEquals((String)"Bag should have 3 items", (int)3, (int)bag.size());
        Iterator i = bag.iterator();
        boolean foundA = false;
        while (i.hasNext()) {
            String element = (String)i.next();
            if (!element.equals("A")) continue;
            if (!foundA) {
                foundA = true;
                continue;
            }
            i.remove();
        }
        Assert.assertTrue((String)"Bag should still contain 'A'", (boolean)bag.contains("A"));
        Assert.assertEquals((String)"Bag should have 2 items", (int)2, (int)bag.size());
        Assert.assertEquals((String)"Bag should have 1 'A'", (int)1, (int)bag.getCount((Object)"A"));
    }

    public void testIteratorFail() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        bag.remove((Object)"A");
        try {
            it.next();
            Assert.fail((String)"Should throw ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testIteratorFailNoMore() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        it.next();
        it.next();
        try {
            it.next();
            Assert.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testIteratorFailDoubleRemove() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        it.next();
        Assert.assertEquals((int)3, (int)bag.size());
        it.remove();
        Assert.assertEquals((int)2, (int)bag.size());
        try {
            it.remove();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((int)2, (int)bag.size());
        it.next();
        it.remove();
        Assert.assertEquals((int)1, (int)bag.size());
    }

    public void testToArray() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        Object[] array = bag.toArray();
        int a = 0;
        int b = 0;
        int c = 0;
        int i = 0;
        while (i < array.length) {
            a += array[i].equals("A") ? 1 : 0;
            b += array[i].equals("B") ? 1 : 0;
            c += array[i].equals("C") ? 1 : 0;
            ++i;
        }
        Assert.assertEquals((int)2, (int)a);
        Assert.assertEquals((int)2, (int)b);
        Assert.assertEquals((int)1, (int)c);
    }

    public void testToArrayPopulate() {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        String[] array = bag.toArray(new String[0]);
        int a = 0;
        int b = 0;
        int c = 0;
        int i = 0;
        while (i < array.length) {
            a += array[i].equals("A") ? 1 : 0;
            b += array[i].equals("B") ? 1 : 0;
            c += array[i].equals("C") ? 1 : 0;
            ++i;
        }
        Assert.assertEquals((int)2, (int)a);
        Assert.assertEquals((int)2, (int)b);
        Assert.assertEquals((int)1, (int)c);
    }

    public void testEquals() {
        Bag bag = this.makeBag();
        Bag bag2 = this.makeBag();
        Assert.assertEquals((boolean)true, (boolean)bag.equals(bag2));
        bag.add((Object)"A");
        Assert.assertEquals((boolean)false, (boolean)bag.equals(bag2));
        bag2.add((Object)"A");
        Assert.assertEquals((boolean)true, (boolean)bag.equals(bag2));
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        Assert.assertEquals((boolean)true, (boolean)bag.equals(bag2));
    }

    public void testEqualsHashBag() {
        Bag bag = this.makeBag();
        HashBag bag2 = new HashBag();
        Assert.assertEquals((boolean)true, (boolean)bag.equals(bag2));
        bag.add((Object)"A");
        Assert.assertEquals((boolean)false, (boolean)bag.equals(bag2));
        bag2.add((Object)"A");
        Assert.assertEquals((boolean)true, (boolean)bag.equals(bag2));
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        Assert.assertEquals((boolean)true, (boolean)bag.equals(bag2));
    }

    public void testHashCode() {
        Bag bag = this.makeBag();
        Bag bag2 = this.makeBag();
        Assert.assertEquals((int)0, (int)bag.hashCode());
        Assert.assertEquals((int)0, (int)bag2.hashCode());
        Assert.assertEquals((int)bag.hashCode(), (int)bag2.hashCode());
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        Assert.assertEquals((int)bag.hashCode(), (int)bag2.hashCode());
        int total = 0;
        total += "A".hashCode() ^ 2;
        total += "B".hashCode() ^ 2;
        Assert.assertEquals((int)(total += "C".hashCode() ^ 1), (int)bag.hashCode());
        Assert.assertEquals((int)total, (int)bag2.hashCode());
    }

    public void testEmptyBagSerialization() throws IOException, ClassNotFoundException {
        Bag bag = this.makeBag();
        if (!(bag instanceof Serializable)) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)bag);
        Bag bag2 = (Bag)this.readExternalFormFromBytes(objekt);
        Assert.assertEquals((String)"Bag should be empty", (int)0, (int)bag.size());
        Assert.assertEquals((String)"Bag should be empty", (int)0, (int)bag2.size());
    }

    public void testFullBagSerialization() throws IOException, ClassNotFoundException {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        int size = bag.size();
        if (!(bag instanceof Serializable)) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)bag);
        Bag bag2 = (Bag)this.readExternalFormFromBytes(objekt);
        Assert.assertEquals((String)"Bag should be same size", (int)size, (int)bag.size());
        Assert.assertEquals((String)"Bag should be same size", (int)size, (int)bag2.size());
    }

    public void testEmptyBagCompatibility() throws IOException, ClassNotFoundException {
        Bag bag = this.makeBag();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(bag));
            Assert.assertTrue((String)"Bag is empty", (bag2.size() == 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)bag, (Object)bag2);
        }
    }

    public void testFullBagCompatibility() throws IOException, ClassNotFoundException {
        Bag bag = this.makeBag();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(bag));
            Assert.assertEquals((String)"Bag is the right size", (int)bag.size(), (int)bag2.size());
            Assert.assertEquals((Object)bag, (Object)bag2);
        }
    }
}

