/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.vtime;

import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.vtime.ASMClassFileTransformer;
import co.paralleluniverse.vtime.Clock_;

public class VirtualTimeClassTransformer
extends ASMClassFileTransformer {
    private static final String PACKAGE = Clock_.class.getPackage().getName().replace('.', '/');
    private static final String CLOCK = Type.getInternalName(Clock_.class);

    @Override
    protected boolean filter(String className) {
        return className == null || className.startsWith(PACKAGE);
    }

    @Override
    protected ClassVisitor createVisitor(ClassVisitor next) {
        return new ClassVisitor(327680, next){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (!this.captureTimeCall(owner, name, desc)) {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    }

                    private boolean captureTimeCall(String owner, String name, String desc) {
                        switch (owner) {
                            case "java/lang/Object": {
                                if (!"wait".equals(name) || desc.startsWith("()")) break;
                                return this.callClockMethod("Object_wait", this.instanceToStatic(owner, desc));
                            }
                            case "java/lang/System": {
                                switch (name) {
                                    case "nanoTime": {
                                        return this.callClockMethod("System_nanoTime", desc);
                                    }
                                    case "currentTimeMillis": {
                                        return this.callClockMethod("System_currentTimeMillis", desc);
                                    }
                                }
                                break;
                            }
                            case "java/lang/Thread": {
                                if (!"sleep".equals(name)) break;
                                return this.callClockMethod("Thread_sleep", desc);
                            }
                            case "sun/misc/Unsafe": {
                                if (!"park".equals(name)) break;
                                return this.callClockMethod("Unsafe_park", this.instanceToStatic(owner, desc));
                            }
                        }
                        return false;
                    }

                    private boolean callClockMethod(String name, String desc) {
                        super.visitMethodInsn(184, CLOCK, name, desc, false);
                        return true;
                    }

                    private String instanceToStatic(String owner, String desc) {
                        return "(L" + owner + ";" + desc.substring(1);
                    }
                };
            }
        };
    }
}

