/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.vtime;

import co.paralleluniverse.vtime.Clock;
import co.paralleluniverse.vtime.SystemClock;

public final class VirtualClock {
    private static Clock gClock;
    private static final InheritableThreadLocal<Clock> itlClock;
    private static final ThreadLocal<Clock> tlClock;

    public static void setGlobal(Clock clock) {
        gClock = clock;
    }

    public static void setForCurrentThreadAndChildren(Clock clock) {
        itlClock.set(clock);
    }

    public static void setForCurrentThread(Clock clock) {
        tlClock.set(clock);
    }

    public static void setForChildThreads(Clock clock) {
        Clock current = VirtualClock.get();
        VirtualClock.setForCurrentThreadAndChildren(clock);
        VirtualClock.setForCurrentThread(current);
    }

    public static void setGlobalExceptCurrentThread(Clock clock) {
        Clock current = VirtualClock.get();
        VirtualClock.setGlobal(clock);
        VirtualClock.setForCurrentThread(current);
    }

    public static Clock get() {
        Clock clock = tlClock.get();
        if (clock == null) {
            clock = (Clock)itlClock.get();
        }
        if (clock == null) {
            clock = gClock;
        }
        if (clock == null) {
            clock = SystemClock.instance();
        }
        return clock;
    }

    private VirtualClock() {
    }

    static {
        itlClock = new InheritableThreadLocal();
        tlClock = new ThreadLocal();
    }
}

