/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.vtime;

import co.paralleluniverse.vtime.Clock;
import co.paralleluniverse.vtime.SystemClock;
import sun.misc.Unsafe;

public final class ScaledClock
extends Clock {
    private final Clock source;
    private final double scale;
    private final long startTime;
    private final long startNanos;

    public ScaledClock(Clock source, double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be positive; was " + scale);
        }
        this.source = source;
        this.scale = scale;
        this.startTime = source.currentTimeMillis();
        this.startNanos = source.nanoTime();
    }

    public ScaledClock(double scale) {
        this(SystemClock.instance(), scale);
    }

    public String toString() {
        return "ScaledClock@" + Integer.toHexString(System.identityHashCode(this)) + "{source=" + this.source + " scale=" + this.scale + '}';
    }

    @Override
    long System_currentTimeMillis() {
        return this.startTime + (long)((double)(this.source.System_currentTimeMillis() - this.startTime) * this.scale);
    }

    @Override
    long System_nanoTime() {
        return this.startNanos + (long)((double)(this.source.System_nanoTime() - this.startNanos) * this.scale);
    }

    @Override
    void Object_wait(Object obj, long timeout) throws InterruptedException {
        this.source.Object_wait(obj, (long)((double)timeout / this.scale));
    }

    @Override
    void Thread_sleep(long millis) throws InterruptedException {
        this.source.Thread_sleep((long)((double)millis / this.scale));
    }

    @Override
    void Unsafe_park(Unsafe unsafe, boolean isAbsolute, long timeout) {
        if (timeout <= 0L) {
            ScaledClock.park(unsafe, isAbsolute, timeout);
            return;
        }
        if (!isAbsolute) {
            this.source.Unsafe_park(unsafe, isAbsolute, (long)((double)timeout / this.scale));
        } else {
            this.source.Unsafe_park(unsafe, isAbsolute, this.source.currentTimeMillis() + (long)((double)(timeout - this.currentTimeMillis()) / this.scale));
        }
    }
}

