/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.vtime;

import co.paralleluniverse.vtime.Clock;
import co.paralleluniverse.vtime.ConcurrentSkipListPriorityQueue;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public final class ManualClock
extends Clock {
    private final Queue<Scheduled> waiters = new ConcurrentSkipListPriorityQueue<Scheduled>();
    private final long startTime;
    private volatile long nanos;

    public ManualClock(long startTime) {
        if (startTime < 0L) {
            throw new IllegalArgumentException("startTime must be >= 0; was " + startTime);
        }
        this.startTime = startTime;
        this.nanos = 0L;
    }

    public ManualClock() {
        this(System.currentTimeMillis());
    }

    public String toString() {
        return "ManualClock@" + Integer.toHexString(System.identityHashCode(this)) + "{startTime=" + this.startTime + " nanos=" + this.nanos + '}';
    }

    public synchronized void advance(long duration, TimeUnit unit) {
        Scheduled s;
        if (duration <= 0L) {
            throw new IllegalArgumentException("Duration must be positive; was " + duration);
        }
        this.nanos += unit.toNanos(duration);
        while ((s = this.waiters.peek()) != null && s.deadline <= this.nanos) {
            this.waiters.poll().wakeup();
        }
    }

    @Override
    long System_currentTimeMillis() {
        return this.startTime + TimeUnit.NANOSECONDS.toMillis(this.nanos);
    }

    @Override
    long System_nanoTime() {
        return this.nanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void Object_wait(Object obj, long timeout) throws InterruptedException {
        if (timeout <= 0L) {
            obj.wait(timeout);
        } else {
            long deadline = this.nanos + TimeUnit.MILLISECONDS.toNanos(timeout);
            try {
                InterruptScheduled s = this.interrupt(deadline, Thread.currentThread());
                this.waiters.add(s);
                obj.wait();
                ManualClock manualClock = this;
                synchronized (manualClock) {
                    if (deadline < this.nanos) {
                        s.disable();
                    } else {
                        Thread.interrupted();
                    }
                }
            }
            catch (InterruptedException e) {
                this.handleInterrupted(deadline, e);
            }
        }
    }

    @Override
    void Thread_sleep(long millis) throws InterruptedException {
        if (millis <= 0L) {
            Thread.sleep(millis);
        } else {
            long deadline = this.nanos + TimeUnit.MILLISECONDS.toNanos(millis);
            try {
                this.waiters.add(this.interrupt(deadline, Thread.currentThread()));
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {
                this.handleInterrupted(deadline, e);
            }
        }
    }

    @Override
    void Unsafe_park(Unsafe unsafe, boolean isAbsolute, long timeout) {
        if (timeout <= 0L) {
            ManualClock.park(unsafe, isAbsolute, this.nanos);
        } else {
            long deadline = this.nanos + (isAbsolute ? TimeUnit.MILLISECONDS.toNanos(timeout - this.System_currentTimeMillis()) : timeout);
            this.waiters.add(this.unpark(deadline, Thread.currentThread()));
            if (this.nanos < deadline) {
                ManualClock.park(unsafe, false, 0L);
            }
        }
    }

    private void handleInterrupted(long deadline, InterruptedException e) throws InterruptedException {
        if (this.nanos < deadline) {
            throw e;
        }
        Thread.interrupted();
    }

    static int signum(long x) {
        long y = (x & Long.MAX_VALUE) + Long.MAX_VALUE;
        return (int)(x >> 63 | y >>> 63);
    }

    private Scheduled unpark(long deadline, Thread t) {
        return new Scheduled(deadline, t){

            @Override
            public void wakeup() {
                LockSupport.unpark(this.thread);
            }
        };
    }

    private InterruptScheduled interrupt(long deadline, Thread t) {
        return new InterruptScheduled(deadline, t);
    }

    private static class InterruptScheduled
    extends Scheduled {
        private volatile boolean disabled;

        public InterruptScheduled(long deadline, Thread thread) {
            super(deadline, thread);
        }

        public void disable() {
            this.disabled = true;
        }

        @Override
        public void wakeup() {
            if (!this.disabled) {
                this.thread.interrupt();
            }
        }
    }

    private static abstract class Scheduled
    implements Comparable<Scheduled> {
        final long deadline;
        final Thread thread;

        public Scheduled(long deadline, Thread thread) {
            this.deadline = deadline;
            this.thread = thread;
        }

        @Override
        public int compareTo(Scheduled o) {
            return ManualClock.signum(this.deadline - o.deadline);
        }

        public abstract void wakeup();
    }
}

