/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.vtime;

import co.paralleluniverse.vtime.Clock;
import co.paralleluniverse.vtime.SystemClock;
import sun.misc.Unsafe;

public final class FixedEpochClock
extends Clock {
    private final long offset;
    private final Clock baseClock;
    private final long epoch;

    public FixedEpochClock(long epoch) {
        this(SystemClock.instance(), epoch);
    }

    public FixedEpochClock(Clock baseClock, long epoch) {
        this.baseClock = baseClock;
        this.epoch = epoch;
        this.offset = epoch - baseClock.currentTimeMillis();
    }

    public String toString() {
        return "FixedEpochClock@" + Integer.toHexString(System.identityHashCode(this)) + "{baseClock=" + this.baseClock + " epoch=" + this.epoch + '}';
    }

    @Override
    long System_currentTimeMillis() {
        return this.baseClock.currentTimeMillis() + this.offset;
    }

    @Override
    long System_nanoTime() {
        return this.baseClock.nanoTime() + this.offset * 1000000L;
    }

    @Override
    void Object_wait(Object obj, long timeout) throws InterruptedException {
        this.baseClock.Object_wait(obj, timeout);
    }

    @Override
    void Thread_sleep(long millis) throws InterruptedException {
        this.baseClock.Thread_sleep(millis);
    }

    @Override
    void Unsafe_park(Unsafe unsafe, boolean isAbsolute, long timeout) {
        this.baseClock.Unsafe_park(unsafe, isAbsolute, timeout);
    }
}

