/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.vtime;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.ClassWriter;
import co.paralleluniverse.asm.Type;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

abstract class ASMClassFileTransformer
implements ClassFileTransformer {
    ASMClassFileTransformer() {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (this.filter(className)) {
                return null;
            }
            return this.instrumentClass(classfileBuffer);
        }
        catch (Throwable t) {
            System.err.println("WARNING: Instrumentation by " + this.getClass().getName() + " failed for class " + Type.getType(classBeingRedefined).getClassName() + ": " + t);
            throw t;
        }
    }

    protected abstract boolean filter(String var1);

    protected abstract ClassVisitor createVisitor(ClassVisitor var1);

    protected byte[] instrumentClass(byte[] classfileBuffer) {
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(cr, 0);
        ClassVisitor cv = this.createVisitor(cw);
        cr.accept(cv, 0);
        return cw.toByteArray();
    }
}

