/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.Counter;
import co.paralleluniverse.common.monitoring.MonitoringServices;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberInfo;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.FibersDetailedMonitor;
import co.paralleluniverse.fibers.FibersMXBean;
import co.paralleluniverse.fibers.FibersMonitor;
import co.paralleluniverse.strands.Strand;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;

class JMXFibersMonitor
extends StandardEmitterMBean
implements FibersMonitor,
NotificationListener,
FibersMXBean {
    private final String mbeanName;
    private final FiberScheduler scheduler;
    private boolean registered;
    private long lastCollectTime;
    private final FibersDetailedMonitor details;
    private final Counter activeCount = new Counter();
    private final Counter waitingCount = new Counter();
    private final Counter spuriousWakeupsCounter = new Counter();
    private final Counter timedWakeupsCounter = new Counter();
    private final Counter timedParkLatencyCounter = new Counter();
    private long spuriousWakeups;
    private long meanTimedWakeupLatency;
    private Map<Fiber, StackTraceElement[]> problemFibers;
    private long notificationSequenceNumber = 1L;

    public JMXFibersMonitor(String name, FiberScheduler scheduler, boolean detailedInfo) {
        super(FibersMXBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport());
        this.scheduler = scheduler;
        this.mbeanName = "co.paralleluniverse:type=Fibers,name=" + name;
        this.registerMBean();
        this.lastCollectTime = this.nanoTime();
        this.details = detailedInfo ? new FibersDetailedMonitor() : null;
    }

    protected void registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, mxbeanName);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
        MonitoringServices.getInstance().addPerfNotificationListener(this, this.mbeanName);
    }

    @Override
    public void unregister() {
        try {
            if (this.registered) {
                MonitoringServices.getInstance().removePerfNotificationListener(this);
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.mbeanName));
            }
            this.registered = false;
        }
        catch (InstanceNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("perfTimer".equals(notification.getType())) {
            this.refresh();
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo info = new MBeanNotificationInfo(new String[]{"co.paralleluniverse.fibers.runawayfiber"}, RunawayFiberNotification.class.getName(), "Runaway fiber detected");
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public void refresh() {
        this.collectAndResetCounters();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    private void collectAndResetCounters() {
        if (this.isRegistered()) {
            this.collectAndResetCounters(this.nanoTime() - this.lastCollectTime);
        }
    }

    protected void collectAndResetCounters(long intervalNanos) {
        this.spuriousWakeups = this.spuriousWakeupsCounter.getAndReset();
        long tw = this.timedWakeupsCounter.getAndReset();
        long tpl = this.timedParkLatencyCounter.getAndReset();
        this.meanTimedWakeupLatency = tw != 0L ? tpl / tw : 0L;
        this.lastCollectTime = this.nanoTime();
    }

    private long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public void fiberStarted(Fiber fiber) {
        this.activeCount.inc();
        if (this.details != null) {
            this.details.fiberStarted(fiber);
        }
    }

    @Override
    public void fiberTerminated(Fiber fiber) {
        this.activeCount.dec();
        if (this.details != null) {
            this.details.fiberTerminated(fiber);
        }
    }

    @Override
    public void fiberSuspended() {
        this.waitingCount.inc();
    }

    @Override
    public void fiberResumed() {
        this.waitingCount.dec();
    }

    @Override
    public void spuriousWakeup() {
        this.spuriousWakeupsCounter.inc();
    }

    @Override
    public void timedParkLatency(long ns) {
        this.timedWakeupsCounter.inc();
        this.timedParkLatencyCounter.add(ns);
    }

    @Override
    public void setRunawayFibers(Collection<Fiber> fs) {
        if (fs == null || fs.isEmpty()) {
            this.problemFibers = null;
        } else {
            HashMap<Fiber, StackTraceElement[]> map = new HashMap<Fiber, StackTraceElement[]>();
            for (Fiber f : fs) {
                Thread t = f.getRunningThread();
                String status = t == null ? "hogging the CPU or blocking a thread" : (t.getState() == Thread.State.RUNNABLE ? "hogging the CPU (" + t + ")" : "blocking a thread (" + t + ")");
                StackTraceElement[] st = f.getStackTrace();
                Map<Fiber, StackTraceElement[]> pf = this.problemFibers;
                if (pf == null || !pf.containsKey(f)) {
                    RunawayFiberNotification n = new RunawayFiberNotification(this, this.notificationSequenceNumber++, System.currentTimeMillis(), "Runaway fiber " + f.getName() + " is " + status + ":\n" + Strand.toString(st));
                    this.sendNotification(n);
                }
                map.put(f, st);
            }
            this.problemFibers = map;
        }
    }

    @Override
    public Map<String, String> getRunawayFibers() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Fiber, StackTraceElement[]> e : this.problemFibers.entrySet()) {
            map.put(e.getKey().toString(), Strand.toString(e.getValue()));
        }
        return map;
    }

    @Override
    public int getNumActiveFibers() {
        return (int)this.activeCount.get();
    }

    @Override
    public int getNumRunnableFibers() {
        return this.getNumActiveFibers() - this.getNumWaitingFibers();
    }

    @Override
    public int getNumWaitingFibers() {
        return (int)this.waitingCount.get();
    }

    @Override
    public int getTimedQueueLength() {
        return this.scheduler.getTimedQueueLength();
    }

    @Override
    public long getSpuriousWakeups() {
        return this.spuriousWakeups;
    }

    @Override
    public long getMeanTimedWakeupLatency() {
        return this.meanTimedWakeupLatency;
    }

    @Override
    public long[] getAllFiberIds() {
        if (this.details == null) {
            return null;
        }
        return this.details.getAllFiberIds();
    }

    @Override
    public FiberInfo getFiberInfo(long id, boolean stack) {
        if (this.details == null) {
            return null;
        }
        return this.details.getFiberInfo(id, stack);
    }

    @Override
    public FiberInfo[] getFiberInfo(long[] ids, boolean stack) {
        if (this.details == null) {
            return null;
        }
        return this.details.getFiberInfo(ids, stack);
    }

    private static class RunawayFiberNotification
    extends Notification {
        static final String NAME = "co.paralleluniverse.fibers.runawayfiber";

        public RunawayFiberNotification(String type, Object source, long sequenceNumber, String message) {
            super(NAME, source, sequenceNumber, message);
        }

        public RunawayFiberNotification(Object source, long sequenceNumber, long timeStamp, String message) {
            super(NAME, source, sequenceNumber, timeStamp, message);
        }
    }
}

