/*
 * Decompiled with CFR 0.152.
 */
package co.omise.requests;

import co.omise.Endpoint;
import co.omise.Serializer;
import co.omise.models.OmiseObjectBase;
import co.omise.models.Params;
import co.omise.requests.Request;
import co.omise.requests.ResponseType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public abstract class RequestBuilder<T extends OmiseObjectBase> {
    private final Serializer serializer = Serializer.defaultSerializer();
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    protected static final String POST = "POST";
    protected static final String GET = "GET";
    protected static final String PATCH = "PATCH";
    protected static final String DELETE = "DELETE";

    public Request<T> build() throws IOException {
        return new Request<T>(this.method(), this.path(), this.contentType(), this.payload(), this.type());
    }

    protected String method() {
        return GET;
    }

    protected abstract HttpUrl path() throws IOException;

    protected String contentType() {
        return "application/json";
    }

    protected RequestBody payload() throws IOException {
        return null;
    }

    protected abstract ResponseType<T> type();

    protected RequestBody serialize() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(4096);
        this.serializer().serializeRequestBuilder(stream, this);
        return RequestBody.create((MediaType)JSON_MEDIA_TYPE, (byte[])stream.toByteArray());
    }

    protected Serializer serializer() {
        return this.serializer;
    }

    protected HttpUrl buildUrl(Endpoint endpoint, String path, String ... segments) {
        return new HttpUrlBuilder(endpoint, path, this.serializer).segments(segments).build();
    }

    protected HttpUrl buildUrl(Endpoint endpoint, String path, Params params) {
        Objects.requireNonNull(params);
        return new HttpUrlBuilder(endpoint, path, this.serializer).params(params).build();
    }

    public class HttpUrlBuilder {
        private Endpoint endpoint;
        private String path;
        private String[] segments;
        private Params params;
        private Serializer serializer;

        public HttpUrlBuilder(Endpoint endpoint, String path, Serializer serializer) {
            this.endpoint = endpoint;
            this.path = path;
            this.serializer = serializer;
        }

        public HttpUrlBuilder segments(String ... segments) {
            this.segments = (String[])segments.clone();
            return this;
        }

        public HttpUrlBuilder params(Params params) {
            this.params = params;
            return this;
        }

        public HttpUrl build() {
            Map<String, String> queries;
            Objects.requireNonNull(this.endpoint);
            Objects.requireNonNull(this.path);
            HttpUrl.Builder builder = this.endpoint.buildUrl().addPathSegment(this.path);
            if (this.segments != null) {
                for (String segment : this.segments) {
                    if (segment == null || segment.isEmpty()) continue;
                    builder = builder.addPathSegment(segment);
                }
            }
            if (this.params != null && !(queries = this.params.query(this.serializer)).isEmpty()) {
                for (Map.Entry<String, String> pair : queries.entrySet()) {
                    builder = builder.addQueryParameter(pair.getKey(), pair.getValue());
                }
            }
            return builder.build();
        }
    }
}

