/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models.schedules;

import co.omise.Endpoint;
import co.omise.models.Model;
import co.omise.models.ScopedList;
import co.omise.models.schedules.ChargeSchedule;
import co.omise.models.schedules.Occurrence;
import co.omise.models.schedules.ScheduleOn;
import co.omise.models.schedules.SchedulePeriod;
import co.omise.models.schedules.ScheduleStatus;
import co.omise.models.schedules.TransferSchedule;
import co.omise.requests.RequestBuilder;
import co.omise.requests.ResponseType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class Schedule
extends Model {
    private boolean active;
    private ChargeSchedule charge;
    @JsonProperty(value="end_on")
    private LocalDate endOn;
    @JsonProperty(value="ended_at")
    private DateTime endedAt;
    private long every;
    @JsonProperty(value="in_words")
    private String inWords;
    private String location;
    @JsonProperty(value="next_occurrences_on")
    private List<String> nextOccurrencesOn;
    private ScopedList<Occurrence> occurrences;
    private ScheduleOn on;
    private SchedulePeriod period;
    @JsonProperty(value="start_on")
    private LocalDate startOn;
    private ScheduleStatus status;
    private TransferSchedule transfer;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ChargeSchedule getCharge() {
        return this.charge;
    }

    public void setCharge(ChargeSchedule charge) {
        this.charge = charge;
    }

    public LocalDate getEndOn() {
        return this.endOn;
    }

    public void setEndOn(LocalDate endOn) {
        this.endOn = endOn;
    }

    public DateTime getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(DateTime endedAt) {
        this.endedAt = endedAt;
    }

    public long getEvery() {
        return this.every;
    }

    public void setEvery(long every) {
        this.every = every;
    }

    public String getInWords() {
        return this.inWords;
    }

    public void setInWords(String inWords) {
        this.inWords = inWords;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    public List<String> getNextOccurrencesOn() {
        return this.nextOccurrencesOn;
    }

    public void setNextOccurrencesOn(List<String> nextOccurrencesOn) {
        this.nextOccurrencesOn = nextOccurrencesOn;
    }

    public ScopedList<Occurrence> getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(ScopedList<Occurrence> occurrences) {
        this.occurrences = occurrences;
    }

    public ScheduleOn getOn() {
        return this.on;
    }

    public void setOn(ScheduleOn on) {
        this.on = on;
    }

    public SchedulePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(SchedulePeriod period) {
        this.period = period;
    }

    public LocalDate getStartOn() {
        return this.startOn;
    }

    public void setStartOn(LocalDate startOn) {
        this.startOn = startOn;
    }

    public ScheduleStatus getStatus() {
        return this.status;
    }

    public void setStatus(ScheduleStatus status) {
        this.status = status;
    }

    public TransferSchedule getTransfer() {
        return this.transfer;
    }

    public void setTransfer(TransferSchedule transfer) {
        this.transfer = transfer;
    }

    public static class TransferScheduleListRequestBuilder
    extends RequestBuilder<ScopedList<Schedule>> {
        private ScopedList.Options options;

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(this, Endpoint.API, "transfers", this.serializer()).segments("schedules").params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Schedule>> type() {
            return new ResponseType<ScopedList<Schedule>>(new TypeReference<ScopedList<Schedule>>(){});
        }

        public TransferScheduleListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class RecipientScheduleListRequestBuilder
    extends RequestBuilder<ScopedList<Schedule>> {
        private String recipientId;
        private ScopedList.Options options;

        public RecipientScheduleListRequestBuilder(String recipientId) {
            this.recipientId = recipientId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(this, Endpoint.API, "recipients", this.serializer()).segments(this.recipientId, "schedules").params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Schedule>> type() {
            return new ResponseType<ScopedList<Schedule>>(new TypeReference<ScopedList<Schedule>>(){});
        }

        public RecipientScheduleListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class CustomerScheduleListRequestBuilder
    extends RequestBuilder<ScopedList<Schedule>> {
        private String customerId;
        private ScopedList.Options options;

        public CustomerScheduleListRequestBuilder(String customerId) {
            this.customerId = customerId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(this, Endpoint.API, "customers", this.serializer()).segments(this.customerId, "schedules").params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Schedule>> type() {
            return new ResponseType<ScopedList<Schedule>>(new TypeReference<ScopedList<Schedule>>(){});
        }

        public CustomerScheduleListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class ListOccurrencesRequestBuilder
    extends RequestBuilder<ScopedList<Occurrence>> {
        private String scheduleId;
        private ScopedList.Options options;

        public ListOccurrencesRequestBuilder(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(this, Endpoint.API, "schedules", this.serializer()).segments(this.scheduleId, "occurrences").params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Occurrence>> type() {
            return new ResponseType<ScopedList<Occurrence>>(new TypeReference<ScopedList<Occurrence>>(){});
        }

        public ListOccurrencesRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class CreateRequestBuilder
    extends RequestBuilder<Schedule> {
        @JsonProperty
        private ChargeSchedule.Params charge;
        @JsonProperty(value="end_date")
        private LocalDate endDate;
        @JsonProperty
        private long every;
        @JsonProperty
        private ScheduleOn.Params on;
        @JsonProperty
        private SchedulePeriod period;
        @JsonProperty(value="start_date")
        private LocalDate startDate;
        @JsonProperty
        private TransferSchedule.Params transfer;

        @Override
        protected String method() {
            return "POST";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "schedules", new String[0]);
        }

        @Override
        protected ResponseType<Schedule> type() {
            return new ResponseType<Schedule>(Schedule.class);
        }

        public CreateRequestBuilder charge(ChargeSchedule.Params charge) {
            this.charge = charge;
            return this;
        }

        public CreateRequestBuilder endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        public CreateRequestBuilder every(long every) {
            this.every = every;
            return this;
        }

        public CreateRequestBuilder on(ScheduleOn.Params on) {
            this.on = on;
            return this;
        }

        public CreateRequestBuilder period(SchedulePeriod period) {
            this.period = period;
            return this;
        }

        public CreateRequestBuilder startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public CreateRequestBuilder transfer(TransferSchedule.Params transfer) {
            this.transfer = transfer;
            return this;
        }

        @Override
        protected RequestBody payload() throws IOException {
            return this.serialize();
        }
    }

    public static class ListRequestBuilder
    extends RequestBuilder<ScopedList<Schedule>> {
        private ScopedList.Options options;

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(this, Endpoint.API, "schedules", this.serializer()).segments(new String[0]).params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Schedule>> type() {
            return new ResponseType<ScopedList<Schedule>>(new TypeReference<ScopedList<Schedule>>(){});
        }

        public ListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class GetRequestBuilder
    extends RequestBuilder<Schedule> {
        private String scheduleId;

        public GetRequestBuilder(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "schedules", this.scheduleId);
        }

        @Override
        protected ResponseType<Schedule> type() {
            return new ResponseType<Schedule>(Schedule.class);
        }
    }

    public static class DeleteRequestBuilder
    extends RequestBuilder<Schedule> {
        private String scheduleId;

        public DeleteRequestBuilder(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        protected String method() {
            return "DELETE";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "schedules", this.scheduleId);
        }

        @Override
        protected ResponseType<Schedule> type() {
            return new ResponseType<Schedule>(Schedule.class);
        }
    }
}

