/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.Config;
import co.omise.Endpoint;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class Configurer
implements Interceptor {
    private final Config config;

    Configurer(Config config) {
        Objects.requireNonNull(config);
        this.config = config;
    }

    public static Request configure(Config config, Request request) {
        String apiVersion = config.apiVersion();
        Endpoint endpoint = Endpoint.getAllEndpointsByHost().get(request.url().host());
        if (endpoint == null) {
            throw new UnsupportedOperationException("unknown endpoint: " + request.url().host());
        }
        String key = endpoint.authenticationKey(config);
        Request.Builder builder = request.newBuilder().addHeader("User-Agent", config.userAgent()).addHeader("Authorization", Credentials.basic((String)key, (String)"x"));
        if (apiVersion != null && !apiVersion.isEmpty()) {
            builder = builder.addHeader("Omise-Version", apiVersion);
        }
        return builder.build();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(Configurer.configure(this.config, chain.request()));
    }
}

