/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.Client;

public final class Config {
    private final String apiVersion;
    private final String publicKey;
    private final String secretKey;
    private final String userAgent;

    public Config(String apiVersion, String publicKey, String secretKey) {
        this.apiVersion = apiVersion;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.userAgent = this.buildUserAgent();
    }

    private String buildUserAgent() {
        StringBuilder builder = new StringBuilder();
        builder.append("OmiseJava/");
        builder.append(Client.class.getPackage().getImplementationVersion());
        if (this.apiVersion != null && !this.apiVersion.isEmpty()) {
            builder.append(" OmiseAPI/");
            builder.append(this.apiVersion);
        }
        builder.append(" Java/");
        builder.append(System.getProperty("java.version"));
        return builder.toString();
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public String userAgent() {
        return this.userAgent;
    }
}

