/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.ClientException;
import co.omise.Config;
import co.omise.Configurer;
import co.omise.Serializer;
import co.omise.models.OmiseException;
import co.omise.models.OmiseObjectBase;
import co.omise.requests.Request;
import co.omise.requests.Requester;
import co.omise.requests.RequesterImpl;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class Client {
    private final OkHttpClient httpClient;
    private Requester requester;

    private Client(String publicKey, String secretKey) throws ClientException {
        if (publicKey == null && secretKey == null) {
            throw new ClientException(new IllegalArgumentException("The key must have at least one key."));
        }
        Config config = new Config("2019-05-29", publicKey, secretKey);
        this.httpClient = this.buildHttpClient(config);
        Serializer serializer = Serializer.defaultSerializer();
        this.requester = new RequesterImpl(this.httpClient, serializer);
    }

    public Client(Requester requester) {
        this.requester = requester;
        this.httpClient = requester.getHttpClient();
    }

    protected OkHttpClient buildHttpClient(Config config) throws ClientException {
        X509TrustManager trustManager;
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            trustManager = this.getX509TrustManager();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new ClientException(e);
        }
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
        return new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), trustManager).addInterceptor((Interceptor)new Configurer(config)).connectionSpecs(Collections.singletonList(spec)).readTimeout(60L, TimeUnit.SECONDS).build();
    }

    protected X509TrustManager getX509TrustManager() throws KeyStoreException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }

    protected OkHttpClient httpClient() {
        return this.httpClient;
    }

    public <T extends OmiseObjectBase, R extends Request<T>> T sendRequest(R request) throws IOException, OmiseException {
        if (this.requester == null) {
            return null;
        }
        return this.requester.sendRequest(request);
    }

    public static class Builder {
        private String publicKey;
        private String secretKey;

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Client build() throws ClientException {
            return new Client(this.publicKey, this.secretKey);
        }
    }
}

