/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.web;

import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.report.processor.Processor;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.agent.web.WebConfiguration;

public class BodyProcessor
implements Processor {
    private final WebConfiguration webConfiguration;

    public BodyProcessor(ConfigurationRegistry configurationRegistry) {
        this.webConfiguration = configurationRegistry.getConfig(WebConfiguration.class);
    }

    @Override
    public void processBeforeReport(Transaction transaction) {
        this.redactBodyIfNecessary(transaction.getContext(), WebConfiguration.EventType.TRANSACTIONS);
    }

    @Override
    public void processBeforeReport(ErrorCapture error) {
        this.redactBodyIfNecessary(error.getContext(), WebConfiguration.EventType.ERRORS);
    }

    private void redactBodyIfNecessary(TransactionContext context, WebConfiguration.EventType eventType) {
        WebConfiguration.EventType eventTypeConfig = this.webConfiguration.getCaptureBody();
        if (this.hasBody(context.getRequest()) && eventTypeConfig != eventType && eventTypeConfig != WebConfiguration.EventType.ALL) {
            context.getRequest().redactBody();
        }
    }

    private boolean hasBody(Request request) {
        return request.getBody() != null;
    }
}

