/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.stagemonitor.configuration.converter;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.AbstractValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.ValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class UrlValueConverter
extends AbstractValueConverter<URL> {
    public static final ValueConverter<URL> INSTANCE = new UrlValueConverter();

    private UrlValueConverter() {
    }

    @Override
    public URL convert(String s) throws IllegalArgumentException {
        try {
            return new URL(StringUtils.removeTrailingSlash(s));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public String toString(URL value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String toSafeString(URL value) {
        if (value == null) {
            return null;
        }
        String userInfo = value.getUserInfo();
        String urlAsString = value.toString();
        if (userInfo != null) {
            return urlAsString.replace(userInfo, this.getSafeUserInfo(userInfo));
        }
        return urlAsString;
    }

    private String getSafeUserInfo(String userInfo) {
        return userInfo.split(":", 2)[0] + ":XXX";
    }
}

