/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.jctools.queues;

import co.elastic.apm.agent.shaded.jctools.queues.MpmcArrayQueue;
import co.elastic.apm.agent.shaded.jctools.queues.MpscArrayQueue;
import co.elastic.apm.agent.shaded.jctools.queues.MpscCompoundQueue;
import co.elastic.apm.agent.shaded.jctools.queues.MpscLinkedQueue;
import co.elastic.apm.agent.shaded.jctools.queues.SpmcArrayQueue;
import co.elastic.apm.agent.shaded.jctools.queues.SpscArrayQueue;
import co.elastic.apm.agent.shaded.jctools.queues.SpscLinkedQueue;
import co.elastic.apm.agent.shaded.jctools.queues.spec.ConcurrentQueueSpec;
import co.elastic.apm.agent.shaded.jctools.queues.spec.Ordering;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                if (qs.ordering != Ordering.NONE) {
                    return new MpscArrayQueue(qs.capacity);
                }
                return new MpscCompoundQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcArrayQueue(qs.capacity);
            }
            return new MpmcArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedQueue();
        }
        if (qs.isMpsc()) {
            return MpscLinkedQueue.newMpscLinkedQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

