/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.dslplatform.json;

import co.elastic.apm.agent.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.agent.shaded.dslplatform.json.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class StringConverter {
    public static final JsonReader.ReadObject<String> READER = new JsonReader.ReadObject<String>(){

        @Override
        @Nullable
        public String read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            return reader.readString();
        }
    };
    public static final JsonWriter.WriteObject<String> WRITER = new JsonWriter.WriteObject<String>(){

        @Override
        public void write(JsonWriter writer, @Nullable String value) {
            StringConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonWriter.WriteObject<CharSequence> WRITER_CHARS = new JsonWriter.WriteObject<CharSequence>(){

        @Override
        public void write(JsonWriter writer, @Nullable CharSequence value) {
            if (value == null) {
                writer.writeNull();
            } else {
                writer.writeString(value);
            }
        }
    };
    public static final JsonReader.ReadObject<StringBuilder> READER_BUILDER = new JsonReader.ReadObject<StringBuilder>(){

        @Override
        @Nullable
        public StringBuilder read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            return reader.appendString(builder);
        }
    };
    public static final JsonReader.ReadObject<StringBuffer> READER_BUFFER = new JsonReader.ReadObject<StringBuffer>(){

        @Override
        @Nullable
        public StringBuffer read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            StringBuffer builder = new StringBuffer();
            return reader.appendString(builder);
        }
    };

    public static void serializeShortNullable(@Nullable String value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            sw.writeString(value);
        }
    }

    public static void serializeShort(String value, JsonWriter sw) {
        sw.writeString(value);
    }

    public static void serializeNullable(@Nullable String value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            sw.writeString(value);
        }
    }

    public static void serialize(String value, JsonWriter sw) {
        sw.writeString(value);
    }

    public static String deserialize(JsonReader reader) throws IOException {
        return reader.readString();
    }

    @Nullable
    public static String deserializeNullable(JsonReader reader) throws IOException {
        if (reader.last() == 110) {
            if (!reader.wasNull()) {
                throw reader.newParseErrorAt("Expecting 'null' for null constant", 0);
            }
            return null;
        }
        return reader.readString();
    }

    public static ArrayList<String> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(READER);
    }

    public static void deserializeCollection(JsonReader reader, Collection<String> res) throws IOException {
        reader.deserializeCollection(READER, res);
    }

    public static ArrayList<String> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(READER);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<String> res) throws IOException {
        reader.deserializeNullableCollection(READER, res);
    }

    public static void serialize(List<String> list, JsonWriter writer) {
        writer.writeByte((byte)91);
        if (list.size() != 0) {
            writer.writeString(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                writer.writeByte((byte)44);
                writer.writeString(list.get(i));
            }
        }
        writer.writeByte((byte)93);
    }
}

