/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.servlet.ServletApiAdvice;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.web.ResultUtil;
import co.elastic.apm.agent.web.WebConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ServletTransactionHelper {
    public static final String TRANSACTION_ATTRIBUTE = ServletApiAdvice.class.getName() + ".transaction";
    public static final String ASYNC_ATTRIBUTE = ServletApiAdvice.class.getName() + ".async";
    private static final String CONTENT_TYPE_FROM_URLENCODED = "application/x-www-form-urlencoded";
    public static final WildcardMatcher ENDS_WITH_JSP = WildcardMatcher.valueOf("*.jsp");
    public static Set<String> nameInitialized = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Logger logger = LoggerFactory.getLogger(ServletTransactionHelper.class);
    private final Set<String> METHODS_WITH_BODY = new HashSet<String>(Arrays.asList("POST", "PUT", "PATCH", "DELETE"));
    private final ElasticApmTracer tracer;
    private final CoreConfiguration coreConfiguration;
    private final WebConfiguration webConfiguration;

    public ServletTransactionHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.webConfiguration = tracer.getConfig(WebConfiguration.class);
        nameInitialized.clear();
    }

    public static void determineServiceName(@Nullable String servletContextName, ClassLoader servletContextClassLoader, @Nullable String contextPath) {
        if (ElasticApmInstrumentation.tracer == null || !nameInitialized.add(contextPath == null ? "null" : contextPath)) {
            return;
        }
        String serviceName = servletContextName;
        if ("application".equals(serviceName) || "".equals(serviceName) || "/".equals(serviceName)) {
            serviceName = null;
        }
        if (serviceName == null && contextPath != null && !contextPath.isEmpty()) {
            serviceName = contextPath.substring(1);
        }
        if (serviceName != null) {
            ElasticApmInstrumentation.tracer.overrideServiceNameForClassLoader(servletContextClassLoader, serviceName);
        }
    }

    @Nullable
    public Transaction onBefore(ClassLoader classLoader, String servletPath, @Nullable String pathInfo, @Nullable String userAgentHeader, @Nullable String traceContextHeader) {
        if (this.coreConfiguration.isActive() && this.tracer.currentTransaction() == null && !this.isExcluded(servletPath, pathInfo, userAgentHeader)) {
            return (Transaction)this.tracer.startTransaction(TraceContext.fromTraceparentHeader(), traceContextHeader, classLoader).activate();
        }
        return null;
    }

    public void fillRequestContext(Transaction transaction, String protocol, String method, boolean secure, String scheme, String serverName, int serverPort, String requestURI, String queryString, String remoteAddr, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        this.startCaptureBody(transaction, method, contentTypeHeader);
        this.fillRequest(request, protocol, method, secure, scheme, serverName, serverPort, requestURI, queryString, remoteAddr);
    }

    private void startCaptureBody(Transaction transaction, String method, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        if (this.hasBody(contentTypeHeader, method)) {
            if (this.webConfiguration.getCaptureBody() != WebConfiguration.EventType.OFF && contentTypeHeader != null && !contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED) && WildcardMatcher.isAnyMatch(this.webConfiguration.getCaptureContentTypes(), contentTypeHeader)) {
                request.withBodyBuffer();
            } else {
                request.redactBody();
                if (this.webConfiguration.getCaptureBody() == WebConfiguration.EventType.OFF) {
                    this.logger.debug("Not capturing Request body because the capture_body config option is OFF");
                }
                if (contentTypeHeader == null) {
                    this.logger.debug("Not capturing request body because couldn't find Content-Type header");
                } else if (!contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED)) {
                    this.logger.debug("Not capturing body for content type \"{}\". Consider updating the capture_body_content_types configuration option.", (Object)contentTypeHeader);
                }
            }
        }
    }

    public static void setUsernameIfUnset(@Nullable String userName, TransactionContext context) {
        if (context.getUser().getUsername() == null) {
            context.getUser().withUsername(userName);
        }
    }

    public void onAfter(Transaction transaction, @Nullable Throwable exception, boolean committed, int status, String method, @Nullable Map<String, String[]> parameterMap, String servletPath, @Nullable String pathInfo, @Nullable String contentTypeHeader, boolean deactivate) {
        try {
            if (exception != null && "weblogic.servlet.jsp.AddToMapException".equals(exception.getClass().getName())) {
                transaction.ignoreTransaction();
            } else {
                this.doOnAfter(transaction, exception, committed, status, method, parameterMap, servletPath, pathInfo, contentTypeHeader);
            }
        }
        catch (RuntimeException e) {
            this.logger.warn("Exception while capturing Elastic APM transaction", e);
        }
        if (deactivate) {
            transaction.deactivate();
        }
        transaction.end();
    }

    private void doOnAfter(Transaction transaction, @Nullable Throwable exception, boolean committed, int status, String method, @Nullable Map<String, String[]> parameterMap, String servletPath, @Nullable String pathInfo, @Nullable String contentTypeHeader) {
        this.fillRequestParameters(transaction, method, parameterMap, contentTypeHeader);
        if (exception != null && status == 200) {
            status = 500;
        }
        this.fillResponse(transaction.getContext().getResponse(), committed, status);
        transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(status));
        transaction.withType("request");
        this.applyDefaultTransactionName(method, servletPath, pathInfo, transaction);
        if (exception != null) {
            transaction.captureException(exception);
        }
    }

    void applyDefaultTransactionName(String method, String servletPath, @Nullable String pathInfo, Transaction transaction) {
        if (this.webConfiguration.isUsePathAsName() || ENDS_WITH_JSP.matches(servletPath, pathInfo)) {
            StringBuilder transactionName = transaction.getAndOverrideName(11);
            if (transactionName != null) {
                WildcardMatcher groupMatcher = WildcardMatcher.anyMatch(this.webConfiguration.getUrlGroups(), servletPath, pathInfo);
                if (groupMatcher != null) {
                    transactionName.append(method).append(' ').append(groupMatcher.toString());
                } else {
                    transactionName.append(method).append(' ').append(servletPath);
                    if (pathInfo != null) {
                        transactionName.append(pathInfo);
                    }
                }
            }
        } else {
            StringBuilder transactionName = transaction.getAndOverrideName(0);
            if (transactionName != null) {
                transactionName.append(method).append(" unknown route");
            }
        }
    }

    private void fillRequestParameters(Transaction transaction, String method, @Nullable Map<String, String[]> parameterMap, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        if (this.hasBody(contentTypeHeader, method) && this.webConfiguration.getCaptureBody() != WebConfiguration.EventType.OFF && parameterMap != null) {
            this.captureParameters(request, parameterMap, contentTypeHeader);
        }
    }

    public boolean captureParameters(String method, @Nullable String contentTypeHeader) {
        return contentTypeHeader != null && contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED) && this.hasBody(contentTypeHeader, method) && this.webConfiguration.getCaptureBody() != WebConfiguration.EventType.OFF && WildcardMatcher.isAnyMatch(this.webConfiguration.getCaptureContentTypes(), contentTypeHeader);
    }

    private boolean isExcluded(String servletPath, @Nullable String pathInfo, @Nullable String userAgentHeader) {
        boolean isExcluded;
        WildcardMatcher excludeAgentMatcher;
        WildcardMatcher excludeUrlMatcher = WildcardMatcher.anyMatch(this.webConfiguration.getIgnoreUrls(), servletPath, pathInfo);
        if (excludeUrlMatcher != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Not tracing this request as the URL {}{} is ignored by the matcher {}", servletPath, Objects.toString(pathInfo, ""), excludeUrlMatcher);
        }
        WildcardMatcher wildcardMatcher = excludeAgentMatcher = userAgentHeader != null ? WildcardMatcher.anyMatch(this.webConfiguration.getIgnoreUserAgents(), userAgentHeader) : null;
        if (excludeAgentMatcher != null) {
            this.logger.debug("Not tracing this request as the User-Agent {} is ignored by the matcher {}", (Object)userAgentHeader, (Object)excludeAgentMatcher);
        }
        boolean bl = isExcluded = excludeUrlMatcher != null || excludeAgentMatcher != null;
        if (!isExcluded && this.logger.isTraceEnabled()) {
            this.logger.trace("No matcher found for excluding this request with servlet-path: {}, path-info: {} and User-Agent: {}", servletPath, pathInfo, userAgentHeader);
        }
        return isExcluded;
    }

    private void fillResponse(Response response, boolean committed, int status) {
        response.withFinished(true);
        response.withHeadersSent(committed);
        response.withStatusCode(status);
    }

    private void fillRequest(Request request, String protocol, String method, boolean secure, String scheme, String serverName, int serverPort, String requestURI, String queryString, String remoteAddr) {
        request.withHttpVersion(this.getHttpVersion(protocol));
        request.withMethod(method);
        request.getSocket().withEncrypted(secure).withRemoteAddress(remoteAddr);
        request.getUrl().withProtocol(scheme).withHostname(serverName).withPort(serverPort).withPathname(requestURI).withSearch(queryString);
        this.fillFullUrl(request.getUrl(), scheme, serverPort, serverName, requestURI, queryString);
    }

    private boolean hasBody(@Nullable String contentTypeHeader, String method) {
        return this.METHODS_WITH_BODY.contains(method) && contentTypeHeader != null;
    }

    private void captureParameters(Request request, Map<String, String[]> params, @Nullable String contentTypeHeader) {
        if (contentTypeHeader != null && contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED)) {
            for (Map.Entry<String, String[]> param : params.entrySet()) {
                request.addFormUrlEncodedParameters(param.getKey(), param.getValue());
            }
        }
    }

    private void fillFullUrl(Url url, String scheme, int port, String serverName, String requestURI, @Nullable String queryString) {
        StringBuilder fullUrl = url.getFull();
        if (port < 0) {
            port = 80;
        }
        fullUrl.append(scheme);
        fullUrl.append("://");
        fullUrl.append(serverName);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            fullUrl.append(':');
            fullUrl.append(port);
        }
        fullUrl.append(requestURI);
        if (queryString != null) {
            fullUrl.append('?').append(queryString);
        }
    }

    private String getHttpVersion(String protocol) {
        switch (protocol) {
            case "HTTP/1.0": {
                return "1.0";
            }
            case "HTTP/1.1": {
                return "1.1";
            }
            case "HTTP/2.0": {
                return "2.0";
            }
        }
        return protocol.replace("HTTP/", "");
    }

    public static void setTransactionNameByServletClass(@Nullable String method, @Nullable Class<?> servletClass, Transaction transaction) {
        if (servletClass == null) {
            return;
        }
        StringBuilder transactionName = transaction.getAndOverrideName(10);
        if (transactionName == null) {
            return;
        }
        String servletClassName = servletClass.getName();
        transactionName.append(servletClassName, servletClassName.lastIndexOf(46) + 1, servletClassName.length());
        if (method != null) {
            transactionName.append('#');
            switch (method) {
                case "DELETE": {
                    transactionName.append("doDelete");
                    break;
                }
                case "HEAD": {
                    transactionName.append("doHead");
                    break;
                }
                case "GET": {
                    transactionName.append("doGet");
                    break;
                }
                case "OPTIONS": {
                    transactionName.append("doOptions");
                    break;
                }
                case "POST": {
                    transactionName.append("doPost");
                    break;
                }
                case "PUT": {
                    transactionName.append("doPut");
                    break;
                }
                case "TRACE": {
                    transactionName.append("doTrace");
                    break;
                }
                default: {
                    transactionName.append(method);
                }
            }
        }
    }

    public boolean isCaptureHeaders() {
        return this.webConfiguration.isCaptureHeaders();
    }
}

