/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.serialize;

import co.elastic.apm.agent.impl.MetaData;
import co.elastic.apm.agent.impl.context.AbstractContext;
import co.elastic.apm.agent.impl.context.Db;
import co.elastic.apm.agent.impl.context.Http;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.Socket;
import co.elastic.apm.agent.impl.context.SpanContext;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.impl.context.User;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.error.ErrorPayload;
import co.elastic.apm.agent.impl.payload.Agent;
import co.elastic.apm.agent.impl.payload.Framework;
import co.elastic.apm.agent.impl.payload.Language;
import co.elastic.apm.agent.impl.payload.Node;
import co.elastic.apm.agent.impl.payload.Payload;
import co.elastic.apm.agent.impl.payload.ProcessInfo;
import co.elastic.apm.agent.impl.payload.RuntimeInfo;
import co.elastic.apm.agent.impl.payload.Service;
import co.elastic.apm.agent.impl.payload.SystemInfo;
import co.elastic.apm.agent.impl.payload.TransactionPayload;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.SpanCount;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.metrics.MetricSet;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.serialize.MetricRegistrySerializer;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import co.elastic.apm.agent.shaded.dslplatform.json.BoolConverter;
import co.elastic.apm.agent.shaded.dslplatform.json.DslJson;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.agent.shaded.dslplatform.json.NumberConverter;
import co.elastic.apm.agent.shaded.dslplatform.json.StringConverter;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DslJsonSerializer
implements PayloadSerializer,
MetricRegistry.MetricsReporter {
    public static final int BUFFER_SIZE = 16384;
    static final int MAX_VALUE_LENGTH = 1024;
    public static final int MAX_LONG_STRING_VALUE_LENGTH = 10000;
    private static final byte NEW_LINE = 10;
    private static final Logger logger = LoggerFactory.getLogger(DslJsonSerializer.class);
    private static final String[] DISALLOWED_IN_LABEL_KEY = new String[]{".", "*", "\""};
    private static final Collection<String> excludedStackFrames = Arrays.asList("java.lang.reflect", "com.sun", "sun.", "jdk.internal.");
    final JsonWriter jw;
    private final StringBuilder replaceBuilder = new StringBuilder(10001);
    private final StacktraceConfiguration stacktraceConfiguration;
    private final ApmServerClient apmServerClient;
    @Nullable
    private OutputStream os;

    public DslJsonSerializer(StacktraceConfiguration stacktraceConfiguration, ApmServerClient apmServerClient) {
        this.stacktraceConfiguration = stacktraceConfiguration;
        this.apmServerClient = apmServerClient;
        this.jw = new DslJson(new DslJson.Settings()).newWriter(16384);
    }

    @Override
    public void setOutputStream(final OutputStream os) {
        this.os = logger.isTraceEnabled() ? new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                os.write(this.buf, 0, this.size());
                os.flush();
                logger.trace(new String(this.buf, 0, this.size(), Charset.forName("UTF-8")));
            }
        } : os;
        this.jw.reset(this.os);
    }

    @Override
    public void flush() throws IOException {
        this.jw.flush();
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        finally {
            this.jw.reset();
        }
    }

    @Override
    public void serializeMetaDataNdJson(MetaData metaData) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("metadata");
        this.serializeMetadata(metaData);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public void serializeMetadata(MetaData metaData) {
        this.jw.writeByte((byte)123);
        this.serializeService(metaData.getService());
        this.jw.writeByte((byte)44);
        this.serializeProcess(metaData.getProcess());
        this.jw.writeByte((byte)44);
        this.serializeGlobalLabels(metaData.getGlobalLabelKeys(), metaData.getGlobalLabelValues());
        this.serializeSystem(metaData.getSystem());
        this.jw.writeByte((byte)125);
    }

    private void serializeGlobalLabels(ArrayList<String> globalLabelKeys, ArrayList<String> globalLabelValues) {
        if (!globalLabelKeys.isEmpty()) {
            this.writeFieldName("labels");
            this.jw.writeByte((byte)123);
            DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizeLabelKey(globalLabelKeys.get(0), this.replaceBuilder), this.replaceBuilder, this.jw);
            this.jw.writeByte((byte)58);
            DslJsonSerializer.writeStringValue(globalLabelValues.get(0), this.replaceBuilder, this.jw);
            for (int i = 0; i < globalLabelKeys.size(); ++i) {
                this.jw.writeByte((byte)44);
                DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizeLabelKey(globalLabelKeys.get(i), this.replaceBuilder), this.replaceBuilder, this.jw);
                this.jw.writeByte((byte)58);
                DslJsonSerializer.writeStringValue(globalLabelValues.get(i), this.replaceBuilder, this.jw);
            }
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    @Override
    public void serializeTransactionNdJson(Transaction transaction) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("transaction");
        this.serializeTransaction(transaction);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public void serializeSpanNdJson(Span span) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("span");
        this.serializeSpan(span);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public void serializeErrorNdJson(ErrorCapture error) {
        this.jw.writeByte((byte)123);
        this.writeFieldName("error");
        this.serializeError(error);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)10);
    }

    @Override
    public int getBufferSize() {
        return this.jw.size();
    }

    @Override
    public void report(Map<? extends Labels, MetricSet> metricSets) {
        MetricRegistrySerializer.serialize(metricSets, this.replaceBuilder, this.jw);
    }

    @Override
    public void serializeMetrics(MetricRegistry metricRegistry) {
        metricRegistry.report(this);
    }

    @Deprecated
    private void serializeErrorPayload(ErrorPayload payload) {
        this.jw.writeByte((byte)123);
        this.serializeService(payload.getService());
        this.jw.writeByte((byte)44);
        this.serializeProcess(payload.getProcess());
        this.jw.writeByte((byte)44);
        this.serializeSystem(payload.getSystem());
        this.jw.writeByte((byte)44);
        this.serializeErrors(payload.getErrors());
        this.jw.writeByte((byte)125);
    }

    private void serializeErrors(List<ErrorCapture> errors) {
        this.writeFieldName("errors");
        this.jw.writeByte((byte)91);
        if (errors.size() > 0) {
            this.serializeError(errors.get(0));
            for (int i = 1; i < errors.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.serializeError(errors.get(i));
            }
        }
        this.jw.writeByte((byte)93);
    }

    private void serializeError(ErrorCapture errorCapture) {
        this.jw.writeByte((byte)123);
        this.writeTimestamp(errorCapture.getTimestamp());
        this.serializeErrorTransactionInfo(errorCapture.getTransactionInfo());
        if (errorCapture.getTraceContext().hasContent()) {
            this.serializeTraceContext(errorCapture.getTraceContext(), true);
        }
        this.serializeContext(errorCapture.getContext(), errorCapture.getTraceContext());
        this.writeField("culprit", errorCapture.getCulprit());
        this.serializeException(errorCapture.getException());
        this.jw.writeByte((byte)125);
    }

    private void serializeErrorTransactionInfo(ErrorCapture.TransactionInfo errorTransactionInfo) {
        this.writeFieldName("transaction");
        this.jw.writeByte((byte)123);
        if (errorTransactionInfo.getType() != null) {
            this.writeField("type", errorTransactionInfo.getType());
        }
        this.writeLastField("sampled", errorTransactionInfo.isSampled());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeException(@Nullable Throwable exception) {
        this.writeFieldName("exception");
        this.recursiveSerializeException(exception);
    }

    private void recursiveSerializeException(@Nullable Throwable exception) {
        this.jw.writeByte((byte)123);
        if (exception != null) {
            this.writeField("message", String.valueOf(exception.getMessage()));
            this.serializeStacktrace(exception.getStackTrace());
            this.writeFieldName("type");
            this.writeStringValue(exception.getClass().getName());
            Throwable cause = exception.getCause();
            if (cause != null) {
                this.jw.writeByte((byte)44);
                this.writeFieldName("cause");
                this.jw.writeByte((byte)91);
                this.recursiveSerializeException(cause);
                this.jw.writeByte((byte)93);
            }
        }
        this.jw.writeByte((byte)125);
    }

    public String toJsonString(Payload payload) {
        this.jw.reset();
        if (payload instanceof TransactionPayload) {
            this.serializeTransactionPayload((TransactionPayload)payload);
        } else if (payload instanceof ErrorPayload) {
            this.serializeErrorPayload((ErrorPayload)payload);
        }
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(Transaction transaction) {
        this.jw.reset();
        this.serializeTransaction(transaction);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(Span span) {
        this.jw.reset();
        this.serializeSpan(span);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(ErrorCapture error) {
        this.jw.reset();
        this.serializeError(error);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(StackTraceElement stackTraceElement) {
        this.jw.reset();
        this.serializeStackTraceElement(stackTraceElement);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toString() {
        return this.jw.toString();
    }

    @Deprecated
    private void serializeTransactionPayload(TransactionPayload payload) {
        this.jw.writeByte((byte)123);
        this.serializeService(payload.getService());
        this.jw.writeByte((byte)44);
        this.serializeProcess(payload.getProcess());
        this.jw.writeByte((byte)44);
        this.serializeSystem(payload.getSystem());
        this.jw.writeByte((byte)44);
        this.serializeSpans(payload.getSpans());
        this.serializeTransactions(payload);
        this.jw.writeByte((byte)125);
    }

    @Deprecated
    private void serializeTransactions(TransactionPayload payload) {
        this.writeFieldName("transactions");
        this.jw.writeByte((byte)91);
        if (payload.getTransactions().size() > 0) {
            this.serializeTransactions(payload.getTransactions());
        }
        this.jw.writeByte((byte)93);
    }

    private void serializeService(Service service) {
        RuntimeInfo runtime;
        Node node;
        Language language;
        Framework framework;
        this.writeFieldName("service");
        this.jw.writeByte((byte)123);
        this.writeField("name", service.getName());
        this.writeField("environment", service.getEnvironment());
        Agent agent = service.getAgent();
        if (agent != null) {
            this.serializeAgent(agent);
        }
        if ((framework = service.getFramework()) != null) {
            this.serializeFramework(framework);
        }
        if ((language = service.getLanguage()) != null) {
            this.serializeLanguage(language);
        }
        if ((node = service.getNode()) != null && node.hasContents()) {
            this.serializeNode(node);
        }
        if ((runtime = service.getRuntime()) != null) {
            this.serializeRuntime(runtime);
        }
        this.writeLastField("version", service.getVersion());
        this.jw.writeByte((byte)125);
    }

    private void serializeAgent(Agent agent) {
        this.writeFieldName("agent");
        this.jw.writeByte((byte)123);
        this.writeField("name", agent.getName());
        this.writeField("ephemeral_id", agent.getEphemeralId());
        this.writeLastField("version", agent.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeFramework(Framework framework) {
        this.writeFieldName("framework");
        this.jw.writeByte((byte)123);
        this.writeField("name", framework.getName());
        this.writeLastField("version", framework.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeLanguage(Language language) {
        this.writeFieldName("language");
        this.jw.writeByte((byte)123);
        this.writeField("name", language.getName());
        this.writeLastField("version", language.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeNode(Node node) {
        this.writeFieldName("node");
        this.jw.writeByte((byte)123);
        this.writeLastField("configured_name", node.getName());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeRuntime(RuntimeInfo runtime) {
        this.writeFieldName("runtime");
        this.jw.writeByte((byte)123);
        this.writeField("name", runtime.getName());
        this.writeLastField("version", runtime.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeProcess(ProcessInfo process) {
        this.writeFieldName("process");
        this.jw.writeByte((byte)123);
        this.writeField("pid", process.getPid());
        if (process.getPpid() != null) {
            this.writeField("ppid", process.getPpid());
        }
        List<String> argv = process.getArgv();
        this.writeField("argv", argv);
        this.writeLastField("title", process.getTitle());
        this.jw.writeByte((byte)125);
    }

    private void serializeSystem(SystemInfo system) {
        this.writeFieldName("system");
        this.jw.writeByte((byte)123);
        this.serializeContainerInfo(system.getContainerInfo());
        this.serializeKubernetesInfo(system.getKubernetesInfo());
        this.writeField("architecture", system.getArchitecture());
        this.writeField("hostname", system.getHostname());
        this.writeLastField("platform", system.getPlatform());
        this.jw.writeByte((byte)125);
    }

    private void serializeContainerInfo(@Nullable SystemInfo.Container container) {
        if (container != null) {
            this.writeFieldName("container");
            this.jw.writeByte((byte)123);
            this.writeLastField("id", container.getId());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeKubernetesInfo(@Nullable SystemInfo.Kubernetes kubernetes) {
        if (kubernetes != null && kubernetes.hasContent()) {
            this.writeFieldName("kubernetes");
            this.jw.writeByte((byte)123);
            this.serializeKubeNodeInfo(kubernetes.getNode());
            this.serializeKubePodInfo(kubernetes.getPod());
            this.writeLastField("namespace", kubernetes.getNamespace());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeKubePodInfo(@Nullable SystemInfo.Kubernetes.Pod pod) {
        if (pod != null) {
            this.writeFieldName("pod");
            this.jw.writeByte((byte)123);
            String podName = pod.getName();
            if (podName != null) {
                this.writeField("name", podName);
            }
            this.writeLastField("uid", pod.getUid());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeKubeNodeInfo(@Nullable SystemInfo.Kubernetes.Node node) {
        if (node != null) {
            this.writeFieldName("node");
            this.jw.writeByte((byte)123);
            this.writeLastField("name", node.getName());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeTransactions(List<Transaction> transactions) {
        this.serializeTransaction(transactions.get(0));
        for (int i = 1; i < transactions.size(); ++i) {
            this.jw.writeByte((byte)44);
            this.serializeTransaction(transactions.get(i));
        }
    }

    private void serializeTransaction(Transaction transaction) {
        this.jw.writeByte((byte)123);
        this.writeTimestamp(transaction.getTimestamp());
        this.writeField("name", transaction.getNameForSerialization());
        this.serializeTraceContext(transaction.getTraceContext(), false);
        this.writeField("type", transaction.getType());
        this.writeField("duration", transaction.getDurationMs());
        this.writeField("result", transaction.getResult());
        this.serializeContext(transaction.getContext(), transaction.getTraceContext());
        this.serializeSpanCount(transaction.getSpanCount());
        this.writeLastField("sampled", transaction.isSampled());
        this.jw.writeByte((byte)125);
    }

    private void serializeTraceContext(TraceContext traceContext, boolean serializeTransactionId) {
        this.writeHexField("id", traceContext.getId());
        if (!traceContext.getTraceId().isEmpty()) {
            this.writeHexField("trace_id", traceContext.getTraceId());
        }
        if (serializeTransactionId && !traceContext.getTransactionId().isEmpty()) {
            this.writeHexField("transaction_id", traceContext.getTransactionId());
        }
        if (!traceContext.getParentId().isEmpty()) {
            this.writeHexField("parent_id", traceContext.getParentId());
        }
    }

    private void serializeSpans(List<Span> spans) {
        if (spans.size() > 0) {
            this.writeFieldName("spans");
            this.jw.writeByte((byte)91);
            this.serializeSpan(spans.get(0));
            for (int i = 1; i < spans.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.serializeSpan(spans.get(i));
            }
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeSpan(Span span) {
        this.jw.writeByte((byte)123);
        this.writeField("name", span.getNameForSerialization());
        this.writeTimestamp(span.getTimestamp());
        this.serializeTraceContext(span.getTraceContext(), true);
        this.writeField("duration", span.getDurationMs());
        if (span.getStacktrace() != null) {
            this.serializeStacktrace(span.getStacktrace().getStackTrace());
        }
        this.serializeSpanContext(span.getContext(), span.getTraceContext());
        this.serializeSpanType(span);
        this.jw.writeByte((byte)125);
    }

    private void serializeServiceName(TraceContext traceContext) {
        String serviceName = traceContext.getServiceName();
        if (serviceName != null) {
            this.writeFieldName("service");
            this.jw.writeByte((byte)123);
            this.writeLastField("name", serviceName);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeSpanType(Span span) {
        this.writeFieldName("type");
        String type = span.getType();
        if (type != null) {
            this.replaceBuilder.setLength(0);
            this.replaceBuilder.append(type);
            DslJsonSerializer.replace(this.replaceBuilder, ".", "_", 0);
            String subtype = span.getSubtype();
            String action = span.getAction();
            if (subtype != null && !subtype.isEmpty() || action != null && !action.isEmpty()) {
                this.replaceBuilder.append('.');
                int replaceStartIndex = this.replaceBuilder.length() + 1;
                if (subtype != null && !subtype.isEmpty()) {
                    this.replaceBuilder.append(subtype);
                    DslJsonSerializer.replace(this.replaceBuilder, ".", "_", replaceStartIndex);
                }
                if (action != null && !action.isEmpty()) {
                    this.replaceBuilder.append('.');
                    replaceStartIndex = this.replaceBuilder.length() + 1;
                    this.replaceBuilder.append(action);
                    DslJsonSerializer.replace(this.replaceBuilder, ".", "_", replaceStartIndex);
                }
            }
            this.writeStringValue(this.replaceBuilder);
        } else {
            this.jw.writeNull();
        }
    }

    private void serializeStacktrace(StackTraceElement[] stacktrace) {
        if (stacktrace.length > 0) {
            this.writeFieldName("stacktrace");
            this.jw.writeByte((byte)91);
            this.serializeStackTraceArrayElements(stacktrace);
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeStackTraceArrayElements(StackTraceElement[] stacktrace) {
        boolean topMostElasticApmPackagesSkipped = false;
        int collectedStackFrames = 0;
        int stackTraceLimit = this.stacktraceConfiguration.getStackTraceLimit();
        for (int i = 0; i < stacktrace.length && collectedStackFrames < stackTraceLimit; ++i) {
            StackTraceElement stackTraceElement = stacktrace[i];
            if (!topMostElasticApmPackagesSkipped && stackTraceElement.getClassName().startsWith("co.elastic.apm")) continue;
            topMostElasticApmPackagesSkipped = true;
            if (DslJsonSerializer.isExcluded(stackTraceElement)) continue;
            if (collectedStackFrames > 0) {
                this.jw.writeByte((byte)44);
            }
            this.serializeStackTraceElement(stackTraceElement);
            ++collectedStackFrames;
        }
    }

    private static boolean isExcluded(StackTraceElement stackTraceElement) {
        if (stackTraceElement.getFileName() == null) {
            return true;
        }
        String className = stackTraceElement.getClassName();
        for (String excludedStackFrame : excludedStackFrames) {
            if (!className.startsWith(excludedStackFrame)) continue;
            return true;
        }
        return false;
    }

    private void serializeStackTraceElement(StackTraceElement stacktrace) {
        this.jw.writeByte((byte)123);
        this.writeField("filename", stacktrace.getFileName());
        this.writeField("function", stacktrace.getMethodName());
        this.writeField("library_frame", this.isLibraryFrame(stacktrace.getClassName()));
        this.writeField("lineno", stacktrace.getLineNumber());
        this.serializeStackFrameModule(stacktrace.getClassName());
        this.jw.writeByte((byte)125);
    }

    private void serializeStackFrameModule(String fullyQualifiedClassName) {
        this.writeFieldName("module");
        this.replaceBuilder.setLength(0);
        int lastDotIndex = fullyQualifiedClassName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            this.replaceBuilder.append(fullyQualifiedClassName, 0, lastDotIndex);
        }
        DslJsonSerializer.writeStringBuilderValue(this.replaceBuilder, this.jw);
    }

    private boolean isLibraryFrame(String className) {
        for (String applicationPackage : this.stacktraceConfiguration.getApplicationPackages()) {
            if (!className.startsWith(applicationPackage)) continue;
            return false;
        }
        return true;
    }

    private void serializeSpanContext(SpanContext context, TraceContext traceContext) {
        this.writeFieldName("context");
        this.jw.writeByte((byte)123);
        this.serializeServiceName(traceContext);
        this.serializeMessageContext(context.getMessage());
        this.serializeDbContext(context.getDb());
        this.serializeHttpContext(context.getHttp());
        this.writeFieldName("tags");
        this.serializeLabels(context);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeMessageContext(Message message) {
        if (message.hasContent()) {
            this.writeFieldName("message");
            this.jw.writeByte((byte)123);
            if (message.getTopicName() != null) {
                this.writeFieldName("topic");
                this.jw.writeByte((byte)123);
                this.writeLastField("name", message.getTopicName());
                this.jw.writeByte((byte)125);
            } else {
                this.writeFieldName("queue");
                this.jw.writeByte((byte)123);
                this.writeLastField("name", message.getQueueName());
                this.jw.writeByte((byte)125);
            }
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeDbContext(Db db) {
        if (db.hasContent()) {
            this.writeFieldName("db");
            this.jw.writeByte((byte)123);
            this.writeField("instance", db.getInstance());
            String statement = db.getStatement();
            if (statement != null) {
                this.writeLongStringField("statement", statement);
            } else {
                CharBuffer statementBuffer = db.getStatementBuffer();
                if (statementBuffer != null && statementBuffer.length() > 0) {
                    this.writeFieldName("statement");
                    this.jw.writeString(statementBuffer);
                    this.jw.writeByte((byte)44);
                }
            }
            long affectedRows = db.getAffectedRowsCount();
            if (affectedRows >= 0L) {
                this.writeField("rows_affected", affectedRows);
            }
            this.writeField("type", db.getType());
            this.writeField("link", db.getDbLink());
            this.writeLastField("user", db.getUser());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeHttpContext(Http http) {
        if (http.hasContent()) {
            this.writeFieldName("http");
            this.jw.writeByte((byte)123);
            this.writeField("method", http.getMethod());
            int statusCode = http.getStatusCode();
            if (statusCode > 0) {
                this.writeField("status_code", http.getStatusCode());
            }
            this.writeLastField("url", http.getUrl());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeSpanCount(SpanCount spanCount) {
        this.writeFieldName("span_count");
        this.jw.writeByte((byte)123);
        this.writeField("dropped", spanCount.getDropped().get());
        this.writeLastField("started", spanCount.getStarted().get());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeContext(TransactionContext context, TraceContext traceContext) {
        this.writeFieldName("context");
        this.jw.writeByte((byte)123);
        this.serializeServiceName(traceContext);
        if (context.getUser().hasContent()) {
            this.serializeUser(context.getUser());
            this.jw.writeByte((byte)44);
        }
        this.serializeRequest(context.getRequest());
        this.serializeResponse(context.getResponse());
        this.serializeMessageContext(context.getMessage());
        if (context.hasCustom()) {
            this.writeFieldName("custom");
            DslJsonSerializer.serializeStringKeyScalarValueMap(context.getCustomIterator(), this.replaceBuilder, this.jw, true, true);
            this.jw.writeByte((byte)44);
        }
        this.writeFieldName("tags");
        this.serializeLabels(context);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    void serializeLabels(AbstractContext context) {
        if (context.hasLabels()) {
            DslJsonSerializer.serializeStringKeyScalarValueMap(context.getLabelIterator(), this.replaceBuilder, this.jw, false, this.apmServerClient.supportsNonStringLabels());
        } else {
            this.jw.writeByte((byte)123);
            this.jw.writeByte((byte)125);
        }
    }

    private static void serializeStringKeyScalarValueMap(Iterator<? extends Map.Entry<String, ?>> it, StringBuilder replaceBuilder, JsonWriter jw, boolean extendedStringLimit, boolean supportsNonStringValues) {
        jw.writeByte((byte)123);
        if (it.hasNext()) {
            Map.Entry<String, ?> kv = it.next();
            DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizeLabelKey(kv.getKey(), replaceBuilder), replaceBuilder, jw);
            jw.writeByte((byte)58);
            DslJsonSerializer.serializeScalarValue(replaceBuilder, jw, kv.getValue(), extendedStringLimit, supportsNonStringValues);
            while (it.hasNext()) {
                jw.writeByte((byte)44);
                kv = it.next();
                DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizeLabelKey(kv.getKey(), replaceBuilder), replaceBuilder, jw);
                jw.writeByte((byte)58);
                DslJsonSerializer.serializeScalarValue(replaceBuilder, jw, kv.getValue(), extendedStringLimit, supportsNonStringValues);
            }
        }
        jw.writeByte((byte)125);
    }

    static void serializeLabels(Labels labels, StringBuilder replaceBuilder, JsonWriter jw) {
        if (!labels.isEmpty()) {
            if (labels.getTransactionName() != null || labels.getTransactionType() != null) {
                DslJsonSerializer.writeFieldName("transaction", jw);
                jw.writeByte((byte)123);
                DslJsonSerializer.writeField("name", labels.getTransactionName(), replaceBuilder, jw);
                DslJsonSerializer.writeLastField("type", labels.getTransactionType(), replaceBuilder, jw);
                jw.writeByte((byte)125);
                jw.writeByte((byte)44);
            }
            if (labels.getSpanType() != null || labels.getSpanSubType() != null) {
                DslJsonSerializer.writeFieldName("span", jw);
                jw.writeByte((byte)123);
                DslJsonSerializer.writeField("type", labels.getSpanType(), replaceBuilder, jw);
                DslJsonSerializer.writeLastField("subtype", labels.getSpanSubType(), replaceBuilder, jw);
                jw.writeByte((byte)125);
                jw.writeByte((byte)44);
            }
            DslJsonSerializer.writeFieldName("tags", jw);
            jw.writeByte((byte)123);
            DslJsonSerializer.serialize(labels, replaceBuilder, jw);
            jw.writeByte((byte)125);
            jw.writeByte((byte)44);
        }
    }

    private static void serialize(Labels labels, StringBuilder replaceBuilder, JsonWriter jw) {
        for (int i = 0; i < labels.size(); ++i) {
            if (i > 0) {
                jw.writeByte((byte)44);
            }
            DslJsonSerializer.writeStringValue(DslJsonSerializer.sanitizeLabelKey(labels.getKey(i), replaceBuilder), replaceBuilder, jw);
            jw.writeByte((byte)58);
            DslJsonSerializer.serializeScalarValue(replaceBuilder, jw, labels.getValue(i), false, false);
        }
    }

    private static void serializeScalarValue(StringBuilder replaceBuilder, JsonWriter jw, Object value, boolean extendedStringLimit, boolean supportsNonStringValues) {
        if (value instanceof String) {
            if (extendedStringLimit) {
                DslJsonSerializer.writeLongStringValue((String)value, replaceBuilder, jw);
            } else {
                DslJsonSerializer.writeStringValue((String)value, replaceBuilder, jw);
            }
        } else if (value instanceof Number) {
            if (supportsNonStringValues) {
                NumberConverter.serialize(((Number)value).doubleValue(), jw);
            } else {
                jw.writeNull();
            }
        } else if (value instanceof Boolean) {
            if (supportsNonStringValues) {
                BoolConverter.serialize((Boolean)value, jw);
            } else {
                jw.writeNull();
            }
        } else {
            jw.writeString("invalid value");
        }
    }

    private static CharSequence sanitizeLabelKey(String key, StringBuilder replaceBuilder) {
        for (int i = 0; i < DISALLOWED_IN_LABEL_KEY.length; ++i) {
            if (!key.contains(DISALLOWED_IN_LABEL_KEY[i])) continue;
            return DslJsonSerializer.replaceAll(key, DISALLOWED_IN_LABEL_KEY, "_", replaceBuilder);
        }
        return key;
    }

    private static CharSequence replaceAll(String s, String[] stringsToReplace, String replacement, StringBuilder replaceBuilder) {
        replaceBuilder.setLength(0);
        replaceBuilder.append(s);
        for (String toReplace : stringsToReplace) {
            DslJsonSerializer.replace(replaceBuilder, toReplace, replacement, 0);
        }
        return replaceBuilder;
    }

    static void replace(StringBuilder replaceBuilder, String toReplace, String replacement, int fromIndex) {
        int i = replaceBuilder.indexOf(toReplace, fromIndex);
        while (i != -1) {
            replaceBuilder.replace(i, i + toReplace.length(), replacement);
            fromIndex = i;
            i = replaceBuilder.indexOf(toReplace, fromIndex);
        }
    }

    private void serializeResponse(Response response) {
        if (response.hasContent()) {
            this.writeFieldName("response");
            this.jw.writeByte((byte)123);
            this.writeField("headers", response.getHeaders());
            this.writeField("finished", response.isFinished());
            this.writeField("headers_sent", response.isHeadersSent());
            this.writeFieldName("status_code");
            NumberConverter.serialize(response.getStatusCode(), this.jw);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeRequest(Request request) {
        if (request.hasContent()) {
            this.writeFieldName("request");
            this.jw.writeByte((byte)123);
            this.writeField("method", request.getMethod());
            this.writeField("headers", request.getHeaders());
            this.writeField("cookies", request.getCookies());
            if (!request.getFormUrlEncodedParameters().isEmpty()) {
                this.writeField("body", request.getFormUrlEncodedParameters());
            } else if (request.getRawBody() != null) {
                this.writeField("body", request.getRawBody());
            } else {
                CharBuffer bodyBuffer = request.getBodyBufferForSerialization();
                if (bodyBuffer != null && bodyBuffer.length() > 0) {
                    this.writeFieldName("body");
                    this.jw.writeString(bodyBuffer);
                    this.jw.writeByte((byte)44);
                }
            }
            if (request.getUrl().hasContent()) {
                this.serializeUrl(request.getUrl());
            }
            if (request.getSocket().hasContent()) {
                this.serializeSocket(request.getSocket());
            }
            this.writeLastField("http_version", request.getHttpVersion());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeUrl(Url url) {
        this.writeFieldName("url");
        this.jw.writeByte((byte)123);
        this.writeField("full", url.getFull());
        this.writeField("hostname", url.getHostname());
        this.writeField("port", url.getPort());
        this.writeField("pathname", url.getPathname());
        this.writeField("search", url.getSearch());
        this.writeLastField("protocol", url.getProtocol());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeSocket(Socket socket) {
        this.writeFieldName("socket");
        this.jw.writeByte((byte)123);
        this.writeField("encrypted", socket.isEncrypted());
        this.writeLastField("remote_address", socket.getRemoteAddress());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void writeField(String fieldName, PotentiallyMultiValuedMap map) {
        if (map.size() > 0) {
            this.writeFieldName(fieldName);
            this.jw.writeByte((byte)123);
            int size = map.size();
            if (size > 0) {
                this.serializePotentiallyMultiValuedEntry(map.getKey(0), map.getValue(0));
                for (int i = 1; i < size; ++i) {
                    this.jw.writeByte((byte)44);
                    this.serializePotentiallyMultiValuedEntry(map.getKey(i), map.getValue(i));
                }
            }
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializePotentiallyMultiValuedEntry(String key, @Nullable Object value) {
        this.jw.writeString(key);
        this.jw.writeByte((byte)58);
        if (value instanceof String) {
            StringConverter.serialize((String)value, this.jw);
        } else if (value instanceof List) {
            this.jw.writeByte((byte)91);
            List values = (List)value;
            this.jw.writeString((String)values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.jw.writeString((String)values.get(i));
            }
            this.jw.writeByte((byte)93);
        } else if (value == null) {
            this.jw.writeNull();
        }
    }

    private void serializeUser(User user) {
        this.writeFieldName("user");
        this.jw.writeByte((byte)123);
        this.writeField("id", user.getId());
        this.writeField("email", user.getEmail());
        this.writeLastField("username", user.getUsername());
        this.jw.writeByte((byte)125);
    }

    void writeField(String fieldName, StringBuilder value) {
        if (value.length() > 0) {
            this.writeFieldName(fieldName);
            this.writeStringBuilderValue(value);
            this.jw.writeByte((byte)44);
        }
    }

    void writeLongStringField(String fieldName, @Nullable String value) {
        if (value != null) {
            this.writeFieldName(fieldName);
            this.writeLongStringValue(value);
            this.jw.writeByte((byte)44);
        }
    }

    void writeField(String fieldName, @Nullable String value) {
        DslJsonSerializer.writeField(fieldName, value, this.replaceBuilder, this.jw);
    }

    static void writeField(String fieldName, @Nullable CharSequence value, StringBuilder replaceBuilder, JsonWriter jw) {
        if (value != null) {
            DslJsonSerializer.writeFieldName(fieldName, jw);
            DslJsonSerializer.writeStringValue(value, replaceBuilder, jw);
            jw.writeByte((byte)44);
        }
    }

    private void writeStringBuilderValue(StringBuilder value) {
        DslJsonSerializer.writeStringBuilderValue(value, this.jw);
    }

    private static void writeStringBuilderValue(StringBuilder value, JsonWriter jw) {
        if (value.length() > 1024) {
            value.setLength(1023);
            value.append('\u2026');
        }
        jw.writeString(value);
    }

    private void writeStringValue(CharSequence value) {
        DslJsonSerializer.writeStringValue(value, this.replaceBuilder, this.jw);
    }

    private static void writeStringValue(CharSequence value, StringBuilder replaceBuilder, JsonWriter jw) {
        if (value.length() > 1024) {
            replaceBuilder.setLength(0);
            replaceBuilder.append(value, 0, Math.min(value.length(), 1025));
            DslJsonSerializer.writeStringBuilderValue(replaceBuilder, jw);
        } else {
            jw.writeString(value);
        }
    }

    private static void writeLongStringBuilderValue(StringBuilder value, JsonWriter jw) {
        if (value.length() > 10000) {
            value.setLength(9999);
            value.append('\u2026');
        }
        jw.writeString(value);
    }

    private void writeLongStringValue(String value) {
        DslJsonSerializer.writeLongStringValue(value, this.replaceBuilder, this.jw);
    }

    private static void writeLongStringValue(String value, StringBuilder replaceBuilder, JsonWriter jw) {
        if (value.length() > 10000) {
            replaceBuilder.setLength(0);
            replaceBuilder.append(value, 0, Math.min(value.length(), 10001));
            DslJsonSerializer.writeLongStringBuilderValue(replaceBuilder, jw);
        } else {
            jw.writeString(value);
        }
    }

    private void writeField(String fieldName, long value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeField(String fieldName, int value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeLastField(String fieldName, int value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
    }

    private void writeField(String fieldName, boolean value) {
        this.writeFieldName(fieldName);
        BoolConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeLastField(String fieldName, boolean value) {
        this.writeFieldName(fieldName);
        BoolConverter.serialize(value, this.jw);
    }

    private void writeField(String fieldName, double value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    void writeLastField(String fieldName, @Nullable String value) {
        DslJsonSerializer.writeLastField(fieldName, value, this.replaceBuilder, this.jw);
    }

    static void writeLastField(String fieldName, @Nullable String value, StringBuilder replaceBuilder, JsonWriter jw) {
        DslJsonSerializer.writeFieldName(fieldName, jw);
        if (value != null) {
            DslJsonSerializer.writeStringValue(value, replaceBuilder, jw);
        } else {
            jw.writeNull();
        }
    }

    public static void writeFieldName(String fieldName, JsonWriter jw) {
        jw.writeByte((byte)34);
        jw.writeAscii(fieldName);
        jw.writeByte((byte)34);
        jw.writeByte((byte)58);
    }

    private void writeFieldName(String fieldName) {
        DslJsonSerializer.writeFieldName(fieldName, this.jw);
    }

    private void writeField(String fieldName, List<String> values) {
        if (values.size() > 0) {
            this.writeFieldName(fieldName);
            this.jw.writeByte((byte)91);
            this.jw.writeString(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.jw.writeString(values.get(i));
            }
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void writeHexField(String fieldName, Id traceId) {
        this.writeFieldName(fieldName);
        this.jw.writeByte((byte)34);
        traceId.writeAsHex(this.jw);
        this.jw.writeByte((byte)34);
        this.jw.writeByte((byte)44);
    }

    private void writeTimestamp(long epochMicros) {
        this.writeFieldName("timestamp");
        NumberConverter.serialize(epochMicros, this.jw);
        this.jw.writeByte((byte)44);
    }
}

