/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import javax.annotation.Nullable;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static String readToString(InputStream inputStream) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder bodyString = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            bodyString.append(line);
        }
        return bodyString.toString();
    }

    public static void consumeAndClose(@Nullable HttpURLConnection connection) {
        if (connection != null) {
            try {
                InputStream responseInputStream = connection.getErrorStream();
                if (responseInputStream == null) {
                    responseInputStream = connection.getInputStream();
                }
                if (responseInputStream != null) {
                    IOUtils.consumeAndClose(responseInputStream);
                }
            }
            catch (Exception e) {
                logger.error("Exception when closing input stream of HttpURLConnection.");
            }
        }
    }
}

