/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis.jedis;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class JedisInstrumentation
extends ElasticApmInstrumentation {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void beforeSendCommand(@Advice.Local(value="span") Span span, @Advice.Origin(value="#m") String method) {
        span = RedisSpanUtils.createRedisSpan(method);
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    private static void afterSendCommand(@Nullable @Advice.Local(value="span") Span span, @Nullable @Advice.Thrown Throwable thrown) {
        if (span != null) {
            ((Span)((Span)span.captureException(thrown)).deactivate()).end();
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("redis.clients.jedis.Jedis").or(ElementMatchers.named("redis.clients.jedis.BinaryJedis")).or(ElementMatchers.named("redis.clients.jedis.ShardedJedis")).or(ElementMatchers.named("redis.clients.jedis.BinaryShardedJedis"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isMethod().and(ElementMatchers.isPublic()).and(ElementMatchers.isOverriddenFrom(ElementMatchers.nameEndsWith("Commands")).and(ElementMatchers.not(ElementMatchers.nameEndsWith("ClusterCommands"))));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "jedis");
    }
}

