/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.plugin.api.ApiInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;

public class CaptureExceptionInstrumentation
extends ApiInstrumentation {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void captureException(@Advice.Origin Class<?> clazz, @Advice.Argument(value=0) Throwable t) {
        if (tracer != null) {
            tracer.captureException(t, clazz.getClassLoader());
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.NoopTransaction").or(ElementMatchers.named("co.elastic.apm.api.NoopSpan"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class));
    }
}

