/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracing.impl;

import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.opentracing.impl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class SpanContextInstrumentation
extends OpenTracingBridgeInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(SpanContextInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public SpanContextInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.TraceContextSpanContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class ToSpanIdInstrumentation
    extends SpanContextInstrumentation {
        public ToSpanIdInstrumentation() {
            super(ElementMatchers.named("toSpanId"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void toTraceId(@Advice.FieldValue(value="traceContext", typing=Assigner.Typing.DYNAMIC) @Nullable TraceContext traceContext, @Advice.Return(readOnly=false) String spanId) {
            if (traceContext != null) {
                spanId = traceContext.getId().toString();
            }
        }
    }

    public static class ToTraceIdInstrumentation
    extends SpanContextInstrumentation {
        public ToTraceIdInstrumentation() {
            super(ElementMatchers.named("toTraceId"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void toTraceId(@Advice.FieldValue(value="traceContext", typing=Assigner.Typing.DYNAMIC) @Nullable TraceContext traceContext, @Advice.Return(readOnly=false) String traceId) {
            if (traceContext != null) {
                traceId = traceContext.getTraceId().toString();
            }
        }
    }

    public static class BaggageItemsInstrumentation
    extends SpanContextInstrumentation {
        public BaggageItemsInstrumentation() {
            super(ElementMatchers.named("baggageItems"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void baggageItems(@Advice.FieldValue(value="traceContext", typing=Assigner.Typing.DYNAMIC) @Nullable TraceContext traceContext, @Advice.Return(readOnly=false) Iterable<Map.Entry<String, String>> baggage) {
            if (traceContext != null) {
                baggage = BaggageItemsInstrumentation.doGetBaggage(traceContext);
            } else {
                logger.info("The traceContext is null");
            }
        }

        public static Iterable<Map.Entry<String, String>> doGetBaggage(TraceContext traceContext) {
            return Collections.singletonMap("elastic-apm-traceparent", traceContext.getOutgoingTraceParentHeader().toString()).entrySet();
        }
    }
}

