/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracing.impl;

import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.opentracing.impl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Map;
import javax.annotation.Nullable;

public class ExternalSpanContextInstrumentation
extends OpenTracingBridgeInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(ExternalSpanContextInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ExternalSpanContextInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ExternalProcessSpanContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Nullable
    public static TraceContext parseTextMap(Iterable<Map.Entry<String, String>> textMap) {
        TraceContext childTraceContext = null;
        if (tracer != null) {
            for (Map.Entry<String, String> next : textMap) {
                if (!"elastic-apm-traceparent".equals(next.getKey())) continue;
                childTraceContext = TraceContext.with64BitId(tracer);
                TraceContext.fromTraceparentHeader().asChildOf(childTraceContext, next.getValue());
                break;
            }
        }
        return childTraceContext;
    }

    public static class ToSpanIdInstrumentation
    extends ExternalSpanContextInstrumentation {
        public ToSpanIdInstrumentation() {
            super(ElementMatchers.named("toSpanId"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void toSpanId(@Advice.FieldValue(value="textMap", typing=Assigner.Typing.DYNAMIC) @Nullable Iterable<Map.Entry<String, String>> textMap, @Advice.FieldValue(value="childTraceContext", typing=Assigner.Typing.DYNAMIC, readOnly=false) @Nullable TraceContext childTraceContext, @Advice.Return(readOnly=false) String spanId) {
            if (textMap != null && childTraceContext == null) {
                childTraceContext = ToSpanIdInstrumentation.parseTextMap(textMap);
            }
            if (childTraceContext != null) {
                spanId = childTraceContext.getParentId().toString();
            }
        }
    }

    public static class ToTraceIdInstrumentation
    extends ExternalSpanContextInstrumentation {
        public ToTraceIdInstrumentation() {
            super(ElementMatchers.named("toTraceId"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void toTraceId(@Advice.FieldValue(value="textMap", typing=Assigner.Typing.DYNAMIC) @Nullable Iterable<Map.Entry<String, String>> textMap, @Advice.FieldValue(value="childTraceContext", typing=Assigner.Typing.DYNAMIC, readOnly=false) @Nullable TraceContext childTraceContext, @Advice.Return(readOnly=false) String traceId) {
            if (textMap != null && childTraceContext == null) {
                childTraceContext = ToTraceIdInstrumentation.parseTextMap(textMap);
            }
            if (childTraceContext != null) {
                traceId = childTraceContext.getTraceId().toString();
            }
        }
    }
}

