/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class OkHttpClientInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public Class<?> getAdviceClass() {
        return OkHttpClientExecuteAdvice.class;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.squareup.okhttp.Call");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.returns(ElementMatchers.named("com.squareup.okhttp.Response")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "okhttp");
    }

    public static class OkHttpClientExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.FieldValue(value="originalRequest", typing=Assigner.Typing.DYNAMIC, readOnly=false) @Nullable Object originalRequest, @Advice.Local(value="span") Span span) {
            Request request;
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            TraceContextHolder<?> parent = ElasticApmInstrumentation.tracer.getActive();
            if (originalRequest == null) {
                return;
            }
            if (originalRequest instanceof Request && (span = HttpClientHelper.startHttpClientSpan(parent, (request = (Request)originalRequest).method(), request.httpUrl().toString(), request.httpUrl().host())) != null) {
                span.activate();
                originalRequest = ((Request)originalRequest).newBuilder().addHeader("elastic-apm-traceparent", span.getTraceContext().getOutgoingTraceParentHeader().toString()).build();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Return @Nullable Response response, @Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                try {
                    if (response != null) {
                        int statusCode = response.code();
                        span.getContext().getHttp().withStatusCode(statusCode);
                    }
                    span.captureException(t);
                }
                finally {
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }
}

