/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.impl.AbstractObjectPool;
import java.io.IOException;
import javax.annotation.Nullable;

public class MixedObjectPool<T>
extends AbstractObjectPool<T> {
    private final ObjectPool<T> primaryPool;
    private final ObjectPool<T> secondaryPool;

    public MixedObjectPool(Allocator<T> allocator, ObjectPool<T> primaryPool, ObjectPool<T> secondaryPool) {
        super(allocator);
        this.primaryPool = primaryPool;
        this.secondaryPool = secondaryPool;
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        T recyclable = this.primaryPool.tryCreateInstance();
        if (recyclable == null) {
            this.secondaryPool.fillFromOtherPool(this.primaryPool, this.primaryPool.getSize());
            return this.primaryPool.tryCreateInstance();
        }
        return recyclable;
    }

    @Override
    public void recycle(T obj) {
        this.secondaryPool.recycle(obj);
    }

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public int getObjectsInPool() {
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.primaryPool.close();
        this.secondaryPool.close();
    }
}

