/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractObjectPool<T>
implements ObjectPool<T> {
    protected final Allocator<T> allocator;
    private final AtomicInteger garbageCreated = new AtomicInteger();

    protected AbstractObjectPool(Allocator<T> allocator) {
        this.allocator = allocator;
    }

    @Override
    public T createInstance() {
        Object recyclable = this.tryCreateInstance();
        if (recyclable == null) {
            this.garbageCreated.incrementAndGet();
            return this.allocator.createInstance();
        }
        return recyclable;
    }

    @Override
    public void fillFromOtherPool(ObjectPool<T> otherPool, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            Object obj = this.tryCreateInstance();
            if (obj == null) {
                return;
            }
            otherPool.recycle(obj);
        }
    }

    @Override
    public long getGarbageCreated() {
        return this.garbageCreated.longValue();
    }
}

