/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jmx;

import co.elastic.apm.agent.jmx.JmxMetric;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import java.util.Collections;
import java.util.List;

public class JmxConfiguration
extends ConfigurationOptionProvider {
    private ConfigurationOption<List<JmxMetric>> captureJmxMetrics = ConfigurationOption.builder(JmxMetric.TokenValueConverter.INSTANCE, List.class).key("capture_jmx_metrics").tags("added[1.11.0]").description("Report metrics from JMX to the APM Server\n\nCan contain multiple comma separated JMX metric definitions:\n\n----\nobject_name[<JMX object name pattern>] attribute[<JMX attribute>:metric_name=<optional metric name>]\n----\n\n* `object_name`:\n+\nFor more information about the JMX object name pattern syntax,\nsee the https://docs.oracle.com/javase/7/docs/api/javax/management/ObjectName.html[`ObjectName` Javadocs].\n* `attribute`:\n+\nThe name of the JMX attribute.\nThe JMX value has to be either a `Number` or a composite where the composite items are numbers.\nThis element can be defined multiple times.\nAn attribute can contain optional properties.\nThe syntax for that is the same as for https://docs.oracle.com/javase/7/docs/api/javax/management/ObjectName.html[`ObjectName`].\n+\n** `metric_name`:\n+\nA property within `attribute`.\nThis is the name under which the metric will be stored.\nSetting this is optional and will be the same as the `attribute` if not set.\nNote that all JMX metric names will be prefixed with `jvm.jmx.` by the agent.\n\nThe agent creates `labels` for each link:https://docs.oracle.com/javase/7/docs/api/javax/management/ObjectName.html#getKeyPropertyList()[JMX key property] such as `type` and `name`.\n\nThe link:https://docs.oracle.com/javase/7/docs/api/javax/management/ObjectName.html[JMX object name pattern] supports wildcards.\nIn this example, the agent will create a metricset for each memory pool `name` (such as `G1 Old Generation` and `G1 Young Generation`)\n\n----\nobject_name[java.lang:type=GarbageCollector,name=*] attribute[CollectionCount:metric_name=collection_count] attribute[CollectionTime]\n----\n\nThe resulting documents in Elasticsearch look similar to these (metadata omitted for brevity):\n\n[source,json]\n----\n{\n  \"@timestamp\": \"2019-08-20T16:51:07.512Z\",\n  \"jvm\": {\n    \"jmx\": {\n      \"collection_count\": 0,\n      \"CollectionTime\":   0\n    }\n  },\n  \"labels\": {\n    \"type\": \"GarbageCollector\",\n    \"name\": \"G1 Old Generation\"\n  }\n}\n----\n\n[source,json]\n----\n{\n  \"@timestamp\": \"2019-08-20T16:51:07.512Z\",\n  \"jvm\": {\n    \"jmx\": {\n      \"collection_count\": 2,\n      \"CollectionTime\":  11\n    }\n  },\n  \"labels\": {\n    \"type\": \"GarbageCollector\",\n    \"name\": \"G1 Young Generation\"\n  }\n}\n----\n\n\nThe agent also supports composite values for the attribute value.\nIn this example, `HeapMemoryUsage` is a composite value, consisting of `committed`, `init`, `used` and `max`.\n----\nobject_name[java.lang:type=Memory] attribute[HeapMemoryUsage:metric_name=heap] \n----\n\nThe resulting documents in Elasticsearch look similar to this:\n\n[source,json]\n----\n{\n  \"@timestamp\": \"2019-08-20T16:51:07.512Z\",\n  \"jvm\": {\n    \"jmx\": {\n      \"heap\": {\n        \"max\":      4294967296,\n        \"init\":      268435456,\n        \"committed\": 268435456,\n        \"used\":       22404496\n      }\n    }\n  },\n  \"labels\": {\n    \"type\": \"Memory\"\n  }\n}\n----\n").dynamic(true).configurationCategory("JMX").buildWithDefault(Collections.emptyList());

    ConfigurationOption<List<JmxMetric>> getCaptureJmxMetrics() {
        return this.captureJmxMetrics;
    }
}

