/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;

public class MessagingConfiguration
extends ConfigurationOptionProvider {
    private static final String MESSAGING_CATEGORY = "Messaging";
    private static final String MESSAGE_POLLING_TRANSACTION_STRATEGY = "message_polling_transaction_strategy";
    private ConfigurationOption<Strategy> messagePollingTransaction = ConfigurationOption.enumOption(Strategy.class).key("message_polling_transaction_strategy").configurationCategory("Messaging").tags("internal").description("Determines whether the agent should create transactions for the polling action itself (e.g. `javax.jms.MessageConsumer#receive`), \nattempt to create a transaction for the message handling code occurring if the polling method returns a message, \nor both. Valid options are: `POLLING`, `HANDLING` and `BOTH`. \n\nThis option is case-insensitive.").dynamic(true).buildWithDefault(Strategy.HANDLING);

    public Strategy getMessagePollingTransactionStrategy() {
        return this.messagePollingTransaction.get();
    }

    public static enum Strategy {
        POLLING,
        HANDLING,
        BOTH;

    }
}

