/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;

public class JmsInstrumentationHelperImpl
implements JmsInstrumentationHelper<Destination, Message, MessageListener> {
    private static final Logger logger = LoggerFactory.getLogger(JmsInstrumentationHelperImpl.class);
    private final ElasticApmTracer tracer;

    public JmsInstrumentationHelperImpl(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    @Nullable
    public Span startJmsSendSpan(Destination destination, Message message) {
        TraceContextHolder<?> activeSpan = this.tracer.getActive();
        if (activeSpan == null || !activeSpan.isSampled()) {
            return null;
        }
        Span span = activeSpan.createExitSpan();
        if (span == null) {
            return null;
        }
        span.withType("messaging").withSubtype("jms").withAction("send").activate();
        try {
            if (span.isSampled()) {
                span.withName("JMS SEND to ");
                this.addDestinationDetails(destination, (AbstractSpan)span);
            }
            message.setStringProperty(JMS_TRACE_PARENT_HEADER, span.getTraceContext().getOutgoingTraceParentHeader().toString());
        }
        catch (JMSException e) {
            logger.error("Failed to capture JMS span", e);
        }
        return span;
    }

    @Override
    @Nullable
    public MessageListener wrapLambda(@Nullable MessageListener listener) {
        if (listener != null && listener.getClass().getName().contains("/")) {
            return new MessageListenerWrapper(listener);
        }
        return listener;
    }

    @Override
    public void addDestinationDetails(Destination destination, AbstractSpan span) {
        try {
            if (destination instanceof Queue) {
                String queueName = ((Queue)destination).getQueueName();
                ((AbstractSpan)((AbstractSpan)span.appendToName("queue ")).appendToName(queueName)).getContext().getMessage().withQueue(queueName);
            } else if (destination instanceof Topic) {
                String topicName = ((Topic)destination).getTopicName();
                ((AbstractSpan)((AbstractSpan)span.appendToName("topic ")).appendToName(topicName)).getContext().getMessage().withTopic(topicName);
            }
        }
        catch (JMSException e) {
            logger.error("Failed to obtain destination name", e);
        }
    }

    public class MessageListenerWrapper
    implements MessageListener {
        private final MessageListener delegate;

        MessageListenerWrapper(MessageListener delegate) {
            this.delegate = delegate;
        }

        public void onMessage(Message message) {
            this.delegate.onMessage(message);
        }
    }
}

