/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.jms.MessagingConfiguration;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;

public abstract class BaseJmsInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    public static HelperClassManager<JmsInstrumentationHelper<Destination, Message, MessageListener>> jmsInstrHelperManager;
    @Nullable
    public static MessagingConfiguration messagingConfiguration;

    private static synchronized void init(ElasticApmTracer tracer) {
        if (jmsInstrHelperManager == null) {
            jmsInstrHelperManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.jms.JmsInstrumentationHelperImpl", "co.elastic.apm.agent.jms.JmsInstrumentationHelperImpl$MessageListenerWrapper");
        }
        messagingConfiguration = tracer.getConfig(MessagingConfiguration.class);
    }

    BaseJmsInstrumentation(ElasticApmTracer tracer) {
        BaseJmsInstrumentation.init(tracer);
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("jms", "incubating");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("javax.jms.Message"));
    }
}

