/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.signature;

import co.elastic.apm.agent.jdbc.signature.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class SignatureParser {
    private static final int DISABLE_CACHE_THRESHOLD = 512;
    private static final int QUERY_LENGTH_CACHE_LOWER_THRESHOLD = 64;
    private static final int QUERY_LENGTH_CACHE_UPPER_THRESHOLD = 10000;
    private static final ConcurrentMap<String, String[]> signatureCache = new ConcurrentHashMap<String, String[]>(512, 0.5f, Runtime.getRuntime().availableProcessors());
    private final Scanner scanner = new Scanner();

    public void querySignature(String query, StringBuilder signature, boolean preparedStatement) {
        this.querySignature(query, signature, null, preparedStatement);
    }

    public void querySignature(String query, StringBuilder signature, @Nullable StringBuilder dbLink, boolean preparedStatement) {
        String[] cachedSignature;
        boolean cacheable;
        boolean bl = cacheable = preparedStatement && 64 < query.length() && query.length() < 10000;
        if (cacheable && (cachedSignature = (String[])signatureCache.get(query)) != null) {
            signature.append(cachedSignature[0]);
            if (dbLink != null) {
                dbLink.append(cachedSignature[1]);
            }
            return;
        }
        this.scanner.setQuery(query);
        this.parse(query, signature, dbLink);
        if (cacheable && signatureCache.size() <= 512) {
            signatureCache.put(query, new String[]{signature.toString(), dbLink != null ? dbLink.toString() : ""});
        }
    }

    private void parse(String query, StringBuilder signature, @Nullable StringBuilder dbLink) {
        Scanner.Token firstToken = this.scanner.scanWhile(Scanner.Token.COMMENT);
        switch (firstToken) {
            case CALL: {
                signature.append("CALL");
                if (this.scanner.scanUntil(Scanner.Token.IDENT)) {
                    this.appendIdentifiers(signature, dbLink);
                }
                return;
            }
            case DELETE: {
                signature.append("DELETE");
                if (this.scanner.scanUntil(Scanner.Token.FROM) && this.scanner.scanUntil(Scanner.Token.IDENT)) {
                    signature.append(" FROM");
                    this.appendIdentifiers(signature, dbLink);
                }
                return;
            }
            case INSERT: 
            case REPLACE: {
                signature.append(firstToken.name());
                if (this.scanner.scanUntil(Scanner.Token.INTO) && this.scanner.scanUntil(Scanner.Token.IDENT)) {
                    signature.append(" INTO");
                    this.appendIdentifiers(signature, dbLink);
                }
                return;
            }
            case SELECT: {
                signature.append("SELECT");
                int level = 0;
                Scanner.Token t = this.scanner.scan();
                while (t != Scanner.Token.EOF) {
                    if (t == Scanner.Token.LPAREN) {
                        ++level;
                    } else if (t == Scanner.Token.RPAREN) {
                        --level;
                    } else if (t == Scanner.Token.FROM && level == 0) {
                        if (this.scanner.scanToken(Scanner.Token.IDENT)) {
                            signature.append(" FROM");
                            this.appendIdentifiers(signature, dbLink);
                        } else {
                            return;
                        }
                    }
                    t = this.scanner.scan();
                }
                return;
            }
            case UPDATE: {
                signature.append("UPDATE");
                boolean hasPeriod = false;
                boolean hasFirstPeriod = false;
                boolean isDbLink = false;
                if (this.scanner.scanToken(Scanner.Token.IDENT)) {
                    signature.append(' ');
                    this.scanner.appendCurrentTokenText(signature);
                    Scanner.Token t = this.scanner.scan();
                    while (t != Scanner.Token.EOF) {
                        switch (t) {
                            case IDENT: {
                                if (hasPeriod) {
                                    this.scanner.appendCurrentTokenText(signature);
                                    hasPeriod = false;
                                }
                                if (!hasFirstPeriod) {
                                    signature.setLength(0);
                                    signature.append("UPDATE ");
                                    this.scanner.appendCurrentTokenText(signature);
                                    break;
                                }
                                if (!isDbLink) break;
                                if (dbLink != null) {
                                    this.scanner.appendCurrentTokenText(dbLink);
                                }
                                isDbLink = false;
                                break;
                            }
                            case PERIOD: {
                                hasFirstPeriod = true;
                                hasPeriod = true;
                                signature.append('.');
                                break;
                            }
                            default: {
                                if ("@".equals(this.scanner.text())) {
                                    isDbLink = true;
                                    break;
                                }
                                return;
                            }
                        }
                        t = this.scanner.scan();
                    }
                }
                return;
            }
            case MERGE: {
                signature.append("MERGE");
                if (this.scanner.scanToken(Scanner.Token.INTO) && this.scanner.scanUntil(Scanner.Token.IDENT)) {
                    signature.append(" INTO");
                    this.appendIdentifiers(signature, dbLink);
                }
                return;
            }
        }
        query = query.trim();
        int indexOfWhitespace = query.indexOf(32);
        signature.append(query, 0, indexOfWhitespace > 0 ? indexOfWhitespace : query.length());
    }

    private void appendIdentifiers(StringBuilder signature, @Nullable StringBuilder dbLink) {
        signature.append(' ');
        this.scanner.appendCurrentTokenText(signature);
        boolean connectedIdents = false;
        boolean isDbLink = false;
        Scanner.Token t = this.scanner.scan();
        while (t != Scanner.Token.EOF) {
            switch (t) {
                case IDENT: {
                    if (connectedIdents) {
                        this.scanner.appendCurrentTokenText(signature);
                        connectedIdents = false;
                        break;
                    }
                    if (isDbLink && dbLink != null) {
                        this.scanner.appendCurrentTokenText(dbLink);
                    }
                    return;
                }
                case PERIOD: {
                    signature.append('.');
                    connectedIdents = true;
                    break;
                }
                case USING: {
                    return;
                }
                default: {
                    if (!"@".equals(this.scanner.text())) break;
                    isDbLink = true;
                }
            }
            t = this.scanner.scan();
        }
    }
}

