/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Collections;

public class ConnectionInstrumentation
extends ElasticApmInstrumentation {
    static final String JDBC_INSTRUMENTATION_GROUP = "jdbc";

    @Advice.OnMethodExit(suppress=Throwable.class)
    public static void storeSql(@Advice.Return PreparedStatement statement, @Advice.Argument(value=0) String sql) {
        JdbcHelper.mapStatementToSql(statement, sql);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Connection");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.Connection")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("prepare").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.PreparedStatement")))).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic());
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton(JDBC_INSTRUMENTATION_GROUP);
    }
}

