/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.agent.util.HexUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class Id
implements Recyclable {
    private final byte[] data;
    private boolean empty = true;
    @Nullable
    private String cachedStringRepresentation;

    public static Id new128BitId() {
        return new Id(16);
    }

    public static Id new64BitId() {
        return new Id(8);
    }

    private Id(int idLengthBytes) {
        this.data = new byte[idLengthBytes];
    }

    public void setToRandomValue() {
        this.setToRandomValue(ThreadLocalRandom.current());
    }

    public void setToRandomValue(Random random) {
        random.nextBytes(this.data);
        this.onMutation(false);
    }

    public void fromHexString(String hexEncodedString, int offset) {
        HexUtils.nextBytes(hexEncodedString, offset, this.data);
        this.onMutation();
    }

    public void fromBytes(byte[] bytes, int offset) {
        System.arraycopy(bytes, offset, this.data, 0, this.data.length);
        this.onMutation();
    }

    public void toBytes(byte[] bytes, int offset) {
        System.arraycopy(this.data, 0, bytes, offset, this.data.length);
    }

    public void fromLongs(long ... values) {
        if (values.length * 8 != this.data.length) {
            throw new IllegalArgumentException("Invalid number of long values");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.data);
        for (long value : values) {
            buffer.putLong(value);
        }
        this.onMutation();
    }

    @Override
    public void resetState() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.onMutation(true);
    }

    public void copyFrom(Id other) {
        System.arraycopy(other.data, 0, this.data, 0, this.data.length);
        this.cachedStringRepresentation = other.cachedStringRepresentation;
        this.empty = other.empty;
    }

    private void onMutation() {
        this.onMutation(Id.isAllZeros(this.data));
    }

    private void onMutation(boolean empty) {
        this.cachedStringRepresentation = null;
        this.empty = empty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id that = (Id)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        String s = this.cachedStringRepresentation;
        if (s == null) {
            s = this.cachedStringRepresentation = HexUtils.bytesToHex(this.data);
        }
        return s;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private static boolean isAllZeros(byte[] bytes) {
        for (byte b : bytes) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public void writeAsHex(JsonWriter jw) {
        HexUtils.writeBytesAsHex(this.data, jw);
    }

    public void writeAsHex(StringBuilder sb) {
        HexUtils.writeBytesAsHex(this.data, sb);
    }

    public long getLeastSignificantBits() {
        return this.readLong(this.data.length - 8);
    }

    public long readLong(int offset) {
        long lsb = 0L;
        for (int i = offset; i < offset + 8; ++i) {
            lsb = lsb << 8 | (long)(this.data[i] & 0xFF);
        }
        return lsb;
    }

    int getLength() {
        return this.data.length;
    }
}

