/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServiceNameUtil;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.async.ContextInScopeCallableWrapper;
import co.elastic.apm.agent.impl.async.ContextInScopeRunnableWrapper;
import co.elastic.apm.agent.impl.async.SpanInScopeCallableWrapper;
import co.elastic.apm.agent.impl.async.SpanInScopeRunnableWrapper;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.sampling.ProbabilitySampler;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.AtomicQueueFactory;
import co.elastic.apm.agent.shaded.jctools.queues.spec.ConcurrentQueueSpec;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ElasticApmTracer {
    private static final Logger logger = LoggerFactory.getLogger(ElasticApmTracer.class);
    private static final int MAX_POOLED_RUNNABLES = 256;
    private long lastSpanMaxWarningTimestamp;
    public static final long MAX_LOG_INTERVAL_MICRO_SECS = TimeUnit.MINUTES.toMicros(5L);
    private final ConfigurationRegistry configurationRegistry;
    private final StacktraceConfiguration stacktraceConfiguration;
    private final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();
    private final ObjectPool<Transaction> transactionPool;
    private final ObjectPool<Span> spanPool;
    private final ObjectPool<ErrorCapture> errorPool;
    private final ObjectPool<SpanInScopeRunnableWrapper> runnableSpanWrapperObjectPool;
    private final ObjectPool<SpanInScopeCallableWrapper<?>> callableSpanWrapperObjectPool;
    private final ObjectPool<ContextInScopeRunnableWrapper> runnableContextWrapperObjectPool;
    private final ObjectPool<ContextInScopeCallableWrapper<?>> callableContextWrapperObjectPool;
    private final Reporter reporter;
    private final ThreadLocal<Deque<TraceContextHolder<?>>> activeStack = new ThreadLocal<Deque<TraceContextHolder<?>>>(){

        @Override
        protected Deque<TraceContextHolder<?>> initialValue() {
            return new ArrayDeque();
        }
    };
    private final ThreadLocal<Boolean> allowWrappingOnThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private final CoreConfiguration coreConfiguration;
    private final List<ActivationListener> activationListeners;
    private final MetricRegistry metricRegistry;
    private Sampler sampler;
    boolean assertionsEnabled = false;
    private static final WeakConcurrentMap<ClassLoader, String> serviceNameByClassLoader = new WeakConcurrentMap.WithInlinedExpunction<ClassLoader, String>();

    ElasticApmTracer(ConfigurationRegistry configurationRegistry, Reporter reporter) {
        this.metricRegistry = new MetricRegistry(configurationRegistry.getConfig(ReporterConfiguration.class));
        this.configurationRegistry = configurationRegistry;
        this.reporter = reporter;
        this.stacktraceConfiguration = configurationRegistry.getConfig(StacktraceConfiguration.class);
        int maxPooledElements = configurationRegistry.getConfig(ReporterConfiguration.class).getMaxQueueSize() * 2;
        this.coreConfiguration = configurationRegistry.getConfig(CoreConfiguration.class);
        this.transactionPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(maxPooledElements)), false, new Allocator<Transaction>(){

            @Override
            public Transaction createInstance() {
                return new Transaction(ElasticApmTracer.this);
            }
        });
        this.spanPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(maxPooledElements)), false, new Allocator<Span>(){

            @Override
            public Span createInstance() {
                return new Span(ElasticApmTracer.this);
            }
        });
        this.errorPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(maxPooledElements / 2)), false, new Allocator<ErrorCapture>(){

            @Override
            public ErrorCapture createInstance() {
                return new ErrorCapture(ElasticApmTracer.this);
            }
        });
        this.runnableSpanWrapperObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new Allocator<SpanInScopeRunnableWrapper>(){

            @Override
            public SpanInScopeRunnableWrapper createInstance() {
                return new SpanInScopeRunnableWrapper(ElasticApmTracer.this);
            }
        });
        this.callableSpanWrapperObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new Allocator<SpanInScopeCallableWrapper<?>>(){

            @Override
            public SpanInScopeCallableWrapper<?> createInstance() {
                return new SpanInScopeCallableWrapper(ElasticApmTracer.this);
            }
        });
        this.runnableContextWrapperObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new Allocator<ContextInScopeRunnableWrapper>(){

            @Override
            public ContextInScopeRunnableWrapper createInstance() {
                return new ContextInScopeRunnableWrapper(ElasticApmTracer.this);
            }
        });
        this.callableContextWrapperObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new Allocator<ContextInScopeCallableWrapper<?>>(){

            @Override
            public ContextInScopeCallableWrapper<?> createInstance() {
                return new ContextInScopeCallableWrapper(ElasticApmTracer.this);
            }
        });
        this.sampler = ProbabilitySampler.of(this.coreConfiguration.getSampleRate().get());
        this.coreConfiguration.getSampleRate().addChangeListener(new ConfigurationOption.ChangeListener<Double>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, Double oldValue, Double newValue) {
                ElasticApmTracer.this.sampler = ProbabilitySampler.of(newValue);
            }
        });
        this.activationListeners = DependencyInjectingServiceLoader.load(ActivationListener.class, this);
        reporter.scheduleMetricReporting(this.metricRegistry, configurationRegistry.getConfig(ReporterConfiguration.class).getMetricsIntervalMs());
        if (!$assertionsDisabled) {
            this.assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    public <T> Transaction startRootTransaction(@Nullable ClassLoader initiatingClassLoader) {
        return this.startTransaction(TraceContext.asRoot(), null, initiatingClassLoader);
    }

    public <T> Transaction startTransaction(TraceContext.ChildContextCreator<T> childContextCreator, @Nullable T parent, @Nullable ClassLoader initiatingClassLoader) {
        return this.startTransaction(childContextCreator, parent, this.sampler, -1L, initiatingClassLoader);
    }

    public void avoidWrappingOnThread() {
        this.allowWrappingOnThread.set(Boolean.FALSE);
    }

    public void allowWrappingOnThread() {
        this.allowWrappingOnThread.set(Boolean.TRUE);
    }

    public boolean isWrappingAllowedOnThread() {
        return this.allowWrappingOnThread.get() == Boolean.TRUE;
    }

    public <T> Transaction startTransaction(TraceContext.ChildContextCreator<T> childContextCreator, @Nullable T parent, Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        String serviceName;
        Transaction transaction = !this.coreConfiguration.isActive() ? this.noopTransaction() : this.createTransaction().start(childContextCreator, parent, epochMicros, sampler, initiatingClassLoader);
        if (logger.isDebugEnabled()) {
            logger.debug("startTransaction {} {", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("starting transaction at", new RuntimeException("this exception is just used to record where the transaction has been started from"));
            }
        }
        if ((serviceName = this.getServiceName(initiatingClassLoader)) != null) {
            transaction.getTraceContext().setServiceName(serviceName);
        }
        return transaction;
    }

    public Transaction noopTransaction() {
        return this.createTransaction().startNoop();
    }

    private Transaction createTransaction() {
        Transaction transaction = this.transactionPool.createInstance();
        while (transaction.getReferenceCount() != 0) {
            logger.warn("Tried to start a transaction with a non-zero reference count {} {}", (Object)transaction.getReferenceCount(), (Object)transaction);
            transaction = this.transactionPool.createInstance();
        }
        return transaction;
    }

    @Nullable
    public Transaction currentTransaction() {
        Deque<TraceContextHolder<?>> stack = this.activeStack.get();
        TraceContextHolder<?> bottomOfStack = stack.peekLast();
        if (bottomOfStack instanceof Transaction) {
            return (Transaction)bottomOfStack;
        }
        if (bottomOfStack != null) {
            Iterator<TraceContextHolder<?>> it = stack.descendingIterator();
            while (it.hasNext()) {
                TraceContextHolder<?> context = it.next();
                if (!(context instanceof Transaction)) continue;
                return (Transaction)context;
            }
        }
        return null;
    }

    public <T> Span startSpan(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext) {
        return this.startSpan(childContextCreator, parentContext, -1L);
    }

    public Span startSpan(AbstractSpan<?> parent, long epochMicros) {
        return this.startSpan(TraceContext.fromParent(), parent, epochMicros);
    }

    public <T> Span startSpan(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext, long epochMicros) {
        boolean dropped;
        Span span = this.createSpan();
        Transaction transaction = this.currentTransaction();
        if (transaction != null) {
            if (this.isTransactionSpanLimitReached(transaction)) {
                if (epochMicros - this.lastSpanMaxWarningTimestamp > MAX_LOG_INTERVAL_MICRO_SECS) {
                    this.lastSpanMaxWarningTimestamp = epochMicros;
                    logger.warn("Max spans ({}) for transaction {} has been reached. For this transaction and possibly others, further spans will be dropped. See config param 'transaction_max_spans'.", (Object)this.coreConfiguration.getTransactionMaxSpans(), (Object)transaction);
                }
                dropped = true;
                transaction.getSpanCount().getDropped().incrementAndGet();
            } else {
                dropped = false;
                transaction.getSpanCount().getStarted().incrementAndGet();
            }
        } else {
            dropped = false;
        }
        span.start(childContextCreator, parentContext, epochMicros, dropped);
        return span;
    }

    private Span createSpan() {
        Span span = this.spanPool.createInstance();
        while (span.getReferenceCount() != 0) {
            logger.warn("Tried to start a span with a non-zero reference count {} {}", (Object)span.getReferenceCount(), (Object)span);
            span = this.spanPool.createInstance();
        }
        return span;
    }

    private boolean isTransactionSpanLimitReached(Transaction transaction) {
        return this.coreConfiguration.getTransactionMaxSpans() <= transaction.getSpanCount().getStarted().get();
    }

    public void captureException(@Nullable Throwable e, ClassLoader initiatingClassLoader) {
        this.captureException(System.currentTimeMillis() * 1000L, e, this.getActive(), initiatingClassLoader);
    }

    public void captureException(long epochMicros, @Nullable Throwable e, TraceContextHolder<?> parent) {
        this.captureException(epochMicros, e, parent, null);
    }

    public void captureException(long epochMicros, @Nullable Throwable e, @Nullable TraceContextHolder<?> parent, @Nullable ClassLoader initiatingClassLoader) {
        if (e != null && !WildcardMatcher.isAnyMatch(this.coreConfiguration.getIgnoreExceptions(), e.getClass().getName())) {
            ErrorCapture error = this.errorPool.createInstance();
            error.withTimestamp(epochMicros);
            error.setException(e);
            Transaction currentTransaction = this.currentTransaction();
            if (currentTransaction != null) {
                error.setTransactionType(currentTransaction.getType());
                error.setTransactionSampled(currentTransaction.isSampled());
            }
            if (parent != null) {
                error.asChildOf(parent);
            } else {
                error.getTraceContext().getId().setToRandomValue();
                error.getTraceContext().setServiceName(this.getServiceName(initiatingClassLoader));
            }
            this.reporter.report(error);
        }
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configurationRegistry;
    }

    public <T extends ConfigurationOptionProvider> T getConfig(Class<T> pluginClass) {
        return this.configurationRegistry.getConfig(pluginClass);
    }

    public void endTransaction(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            logger.debug("} endTransaction {}", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("ending transaction at", new RuntimeException("this exception is just used to record where the transaction has been ended from"));
            }
        }
        if (!transaction.isNoop()) {
            this.reporter.report(transaction);
        } else {
            transaction.decrementReferences();
        }
    }

    public void endSpan(Span span) {
        if (span.isSampled() && !span.isDiscard()) {
            long spanFramesMinDurationMs = this.stacktraceConfiguration.getSpanFramesMinDurationMs();
            if (spanFramesMinDurationMs != 0L && span.isSampled() && span.getDurationMs() >= (double)spanFramesMinDurationMs) {
                span.withStacktrace(new Throwable());
            }
            this.reporter.report(span);
        } else {
            span.decrementReferences();
        }
    }

    public void recycle(Transaction transaction) {
        this.transactionPool.recycle(transaction);
    }

    public void recycle(Span span) {
        this.spanPool.recycle(span);
    }

    public void recycle(ErrorCapture error) {
        this.errorPool.recycle(error);
    }

    public Runnable wrapRunnable(Runnable delegate, AbstractSpan<?> span) {
        if (delegate instanceof SpanInScopeRunnableWrapper) {
            return delegate;
        }
        return this.runnableSpanWrapperObjectPool.createInstance().wrap(delegate, span);
    }

    public void recycle(SpanInScopeRunnableWrapper wrapper) {
        this.runnableSpanWrapperObjectPool.recycle(wrapper);
    }

    public <V> Callable<V> wrapCallable(Callable<V> delegate, AbstractSpan<?> span) {
        if (delegate instanceof SpanInScopeCallableWrapper) {
            return delegate;
        }
        return this.callableSpanWrapperObjectPool.createInstance().wrap(delegate, span);
    }

    public void recycle(SpanInScopeCallableWrapper<?> wrapper) {
        this.callableSpanWrapperObjectPool.recycle(wrapper);
    }

    public Runnable wrapRunnable(Runnable delegate, TraceContext traceContext) {
        if (delegate instanceof ContextInScopeRunnableWrapper || delegate instanceof SpanInScopeRunnableWrapper) {
            return delegate;
        }
        return this.runnableContextWrapperObjectPool.createInstance().wrap(delegate, traceContext);
    }

    public void recycle(ContextInScopeRunnableWrapper wrapper) {
        this.runnableContextWrapperObjectPool.recycle(wrapper);
    }

    public <V> Callable<V> wrapCallable(Callable<V> delegate, TraceContext traceContext) {
        if (delegate instanceof ContextInScopeCallableWrapper || delegate instanceof SpanInScopeCallableWrapper) {
            return delegate;
        }
        return this.callableContextWrapperObjectPool.createInstance().wrap(delegate, traceContext);
    }

    public void recycle(ContextInScopeCallableWrapper<?> callableWrapper) {
        this.callableContextWrapperObjectPool.recycle(callableWrapper);
    }

    public void stop() {
        try {
            this.configurationRegistry.close();
            this.reporter.close();
            this.transactionPool.close();
            this.spanPool.close();
            this.errorPool.close();
        }
        catch (Exception e) {
            logger.warn("Suppressed exception while calling stop()", e);
        }
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.stop();
            }
            catch (Exception e) {
                logger.warn("Suppressed exception while calling stop()", e);
            }
        }
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    @Nullable
    public TraceContextHolder<?> getActive() {
        return this.activeStack.get().peek();
    }

    public void registerSpanListener(ActivationListener activationListener) {
        this.activationListeners.add(activationListener);
    }

    public List<ActivationListener> getActivationListeners() {
        return this.activationListeners;
    }

    void registerLifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        this.lifecycleListeners.addAll(lifecycleListeners);
        for (LifecycleListener lifecycleListener : lifecycleListeners) {
            lifecycleListener.start(this);
        }
    }

    @Nullable
    public <T> T getLifecycleListener(Class<T> listenerClass) {
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            if (!listenerClass.isInstance(lifecycleListener)) continue;
            return (T)lifecycleListener;
        }
        return null;
    }

    public void activate(TraceContextHolder<?> holder) {
        if (logger.isDebugEnabled()) {
            logger.debug("Activating {} on thread {}", (Object)holder, (Object)Thread.currentThread().getId());
        }
        this.activeStack.get().push(holder);
    }

    public void deactivate(TraceContextHolder<?> holder) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deactivating {} on thread {}", (Object)holder, (Object)Thread.currentThread().getId());
        }
        Deque<TraceContextHolder<?>> stack = this.activeStack.get();
        this.assertIsActive(holder, stack.poll());
        if (!stack.isEmpty() && !holder.isDiscard()) {
            stack.peek().setDiscard(false);
        }
    }

    private void assertIsActive(Object span, @Nullable Object currentlyActive) {
        if (span != currentlyActive) {
            logger.warn("Deactivating a span ({}) which is not the currently active span ({}). This can happen when not properly deactivating a previous span.", span, currentlyActive);
            if (this.assertionsEnabled) {
                throw new AssertionError();
            }
        }
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void overrideServiceNameForClassLoader(@Nullable ClassLoader classLoader, @Nullable String serviceName) {
        if (classLoader == null || serviceName == null || serviceName.isEmpty() || !this.coreConfiguration.getServiceNameConfig().isDefault()) {
            return;
        }
        if (!serviceNameByClassLoader.containsKey(classLoader)) {
            serviceNameByClassLoader.putIfAbsent(classLoader, ServiceNameUtil.replaceDisallowedChars(serviceName));
        }
    }

    @Nullable
    private String getServiceName(@Nullable ClassLoader initiatingClassLoader) {
        if (initiatingClassLoader == null) {
            return null;
        }
        return serviceNameByClassLoader.get(initiatingClassLoader);
    }

    public void resetServiceNameOverrides() {
        serviceNameByClassLoader.clear();
    }
}

