/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.httpclient.ApacheHttpAsyncClientHelperImpl;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class HttpAsyncRequestProducerWrapper
implements HttpAsyncRequestProducer,
Recyclable {
    private final ApacheHttpAsyncClientHelperImpl helper;
    private volatile HttpAsyncRequestProducer delegate;
    private Span span;

    HttpAsyncRequestProducerWrapper(ApacheHttpAsyncClientHelperImpl helper) {
        this.helper = helper;
    }

    public HttpAsyncRequestProducerWrapper with(HttpAsyncRequestProducer delegate, Span span) {
        this.span = span;
        this.delegate = delegate;
        return this;
    }

    public HttpHost getTarget() {
        return this.delegate.getTarget();
    }

    public HttpRequest generateRequest() throws IOException, HttpException {
        String hostname;
        HttpHost host;
        HttpRequest request = this.delegate.generateRequest();
        if (request != null) {
            RequestLine requestLine = request.getRequestLine();
            if (requestLine != null) {
                String method = requestLine.getMethod();
                ((Span)this.span.withName(method)).appendToName(" ");
                this.span.getContext().getHttp().withMethod(method).withUrl(requestLine.getUri());
            }
            request.setHeader("elastic-apm-traceparent", this.span.getTraceContext().getOutgoingTraceParentHeader().toString());
        }
        if ((host = this.getTarget()) != null && (hostname = host.getHostName()) != null) {
            this.span.appendToName(hostname);
        }
        return request;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.delegate.produceContent(encoder, ioctrl);
    }

    public void requestCompleted(HttpContext context) {
        this.delegate.requestCompleted(context);
    }

    public void failed(Exception ex) {
        this.delegate.failed(ex);
    }

    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public void resetRequest() throws IOException {
        this.delegate.resetRequest();
    }

    public void close() throws IOException {
        this.delegate.close();
        this.helper.recycle(this);
    }

    @Override
    public void resetState() {
        this.span = null;
        this.delegate = null;
    }
}

