/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.http.HttpRequest;

public class ApacheHttpAsyncClientRedirectInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public Class<?> getAdviceClass() {
        return ApacheHttpAsyncClientRedirectAdvice.class;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("RedirectStrategy");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.RedirectStrategy"));
    }

    @Override
    public ElementMatcher.Junction<ProtectionDomain> getImplementationVersionPostFilter() {
        return CustomElementMatchers.implementationVersionLte("4.3.2");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getRedirect");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "apache-httpclient");
    }

    private static class ApacheHttpAsyncClientRedirectAdvice {
        private ApacheHttpAsyncClientRedirectAdvice() {
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void onAfterExecute(@Advice.Argument(value=0) HttpRequest original, @Advice.Return(typing=Assigner.Typing.DYNAMIC) @Nullable HttpRequest redirect) {
            String traceContext;
            if (ElasticApmInstrumentation.tracer == null || redirect == null) {
                return;
            }
            if (original.containsHeader("elastic-apm-traceparent") && !redirect.containsHeader("elastic-apm-traceparent") && (traceContext = original.getFirstHeader("elastic-apm-traceparent").getValue()) != null) {
                redirect.setHeader("elastic-apm-traceparent", traceContext);
            }
        }
    }
}

