/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.hibernate.search.v5_x;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.hibernate.search.HibernateSearchHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.hibernate.search.query.hibernate.impl.FullTextQueryImpl;

public class HibernateSearch5Instrumentation
extends ElasticApmInstrumentation {
    @Override
    public Class<?> getAdviceClass() {
        return HibernateSearch5ExecuteAdvice.class;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Query");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.hibernate.search.FullTextQuery"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.hibernate.search.FullTextQuery")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("list").or(ElementMatchers.named("scroll")).or(ElementMatchers.named("iterate"));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("hibernate-search");
    }

    public static class HibernateSearch5ExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.This FullTextQueryImpl query, @Advice.Local(value="span") Span span, @Advice.Origin(value="#m") String methodName) {
            span = HibernateSearchHelper.createAndActivateSpan(ElasticApmInstrumentation.tracer, methodName, query.getQueryString());
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Local(value="span") @Nullable Span span, @Advice.Thrown Throwable t) {
            if (span != null) {
                try {
                    span.captureException(t);
                }
                finally {
                    span.end();
                    span.deactivate();
                }
            }
        }
    }
}

