/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.hibernate.search;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;

public final class HibernateSearchHelper {
    private HibernateSearchHelper() {
    }

    public static Span createAndActivateSpan(ElasticApmTracer tracer, String methodName, String query) {
        Span span = null;
        if (tracer != null) {
            TraceContextHolder<?> active = tracer.getActive();
            if (active == null || active instanceof Span && "hibernate-search".equals(((Span)active).getSubtype())) {
                return null;
            }
            span = (Span)active.createSpan().activate();
            span.withType("db").withSubtype("hibernate-search").withAction(methodName);
            span.getContext().getDb().withType("hibernate-search").withStatement(query);
            ((Span)((Span)((Span)span.withName("Hibernate-Search")).appendToName(" ")).appendToName(methodName)).appendToName("()");
        }
        return span;
    }
}

