/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.es.restclient.v5_6;

import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentation;
import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentationHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.elasticsearch.client.Response;

public class ElasticsearchClientSyncInstrumentation
extends ElasticsearchRestClientInstrumentation {
    public ElasticsearchClientSyncInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public Class<?> getAdviceClass() {
        return ElasticsearchRestClientAdvice.class;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.elasticsearch.client.RestClient").and(ElementMatchers.not(ElementMatchers.declaresMethod(ElementMatchers.named("performRequest").and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.elasticsearch.client.Request")))))));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("performRequest").and(ElementMatchers.takesArguments(6).and(ElementMatchers.takesArgument(4, ElementMatchers.named("org.elasticsearch.client.HttpAsyncResponseConsumerFactory"))));
    }

    private static class ElasticsearchRestClientAdvice {
        private ElasticsearchRestClientAdvice() {
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0) String method, @Advice.Argument(value=1) String endpoint, @Advice.Argument(value=3) @Nullable HttpEntity entity, @Advice.Local(value="span") Span span, @Advice.Local(value="helper") ElasticsearchRestClientInstrumentationHelper helper) {
            helper = ElasticsearchRestClientInstrumentation.esClientInstrHelperManager.getForClassLoaderOfClass(Response.class);
            if (helper != null) {
                span = helper.createClientSpan(method, endpoint, entity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Return @Nullable Response response, @Advice.Local(value="span") @Nullable Span span, @Advice.Local(value="helper") @Nullable ElasticsearchRestClientInstrumentationHelper helper, @Advice.Thrown @Nullable Throwable t) {
            if (helper != null && span != null) {
                try {
                    helper.finishClientSpan(response, span, t);
                }
                finally {
                    span.deactivate();
                }
            }
        }
    }
}

