/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.es.restclient;

import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentationHelper;
import co.elastic.apm.agent.es.restclient.ResponseListenerWrapper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.AtomicQueueFactory;
import co.elastic.apm.agent.shaded.jctools.queues.spec.ConcurrentQueueSpec;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.util.IOUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;

public class ElasticsearchRestClientInstrumentationHelperImpl
implements ElasticsearchRestClientInstrumentationHelper<HttpEntity, Response, ResponseListener> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchRestClientInstrumentationHelperImpl.class);
    public static final String SEARCH_QUERY_PATH_SUFFIX = "_search";
    public static final String SPAN_TYPE = "db";
    public static final String ELASTICSEARCH = "elasticsearch";
    public static final String SPAN_ACTION = "request";
    private static final int MAX_POOLED_ELEMENTS = 256;
    private final ElasticApmTracer tracer;
    private final ObjectPool<ResponseListenerWrapper> responseListenerObjectPool;

    public ElasticsearchRestClientInstrumentationHelperImpl(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.responseListenerObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new ResponseListenerAllocator());
    }

    @Override
    @Nullable
    public Span createClientSpan(String method, String endpoint, @Nullable HttpEntity httpEntity) {
        TraceContextHolder<?> activeSpan = this.tracer.getActive();
        if (activeSpan == null || !activeSpan.isSampled()) {
            return null;
        }
        Span span = activeSpan.createExitSpan();
        if (span == null) {
            return null;
        }
        ((Span)((Span)((Span)span.withType(SPAN_TYPE).withSubtype(ELASTICSEARCH).withAction(SPAN_ACTION).appendToName("Elasticsearch: ")).appendToName(method)).appendToName(" ")).appendToName(endpoint);
        span.getContext().getDb().withType(ELASTICSEARCH);
        span.activate();
        if (span.isSampled()) {
            span.getContext().getHttp().withMethod(method);
            if (endpoint.endsWith(SEARCH_QUERY_PATH_SUFFIX) && httpEntity != null && httpEntity.isRepeatable()) {
                try {
                    IOUtils.readUtf8Stream(httpEntity.getContent(), span.getContext().getDb().withStatementBuffer());
                }
                catch (IOException e) {
                    logger.error("Failed to read Elasticsearch client query from request body", e);
                }
            }
        }
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishClientSpan(@Nullable Response response, Span span, @Nullable Throwable t) {
        try {
            String url = null;
            int statusCode = -1;
            if (response != null) {
                url = response.getHost().toURI();
                statusCode = response.getStatusLine().getStatusCode();
            } else if (t != null) {
                if (t instanceof ResponseException) {
                    ResponseException esre = (ResponseException)t;
                    url = esre.getResponse().getHost().toURI();
                    statusCode = esre.getResponse().getStatusLine().getStatusCode();
                }
                span.captureException(t);
            }
            if (url != null && !url.isEmpty()) {
                span.getContext().getHttp().withUrl(url);
            }
            if (statusCode > 0) {
                span.getContext().getHttp().withStatusCode(statusCode);
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public ResponseListener wrapResponseListener(ResponseListener listener, Span span) {
        return this.responseListenerObjectPool.createInstance().with(listener, span);
    }

    void recycle(ResponseListenerWrapper listenerWrapper) {
        this.responseListenerObjectPool.recycle(listenerWrapper);
    }

    private class ResponseListenerAllocator
    implements Allocator<ResponseListenerWrapper> {
        private ResponseListenerAllocator() {
        }

        @Override
        public ResponseListenerWrapper createInstance() {
            return new ResponseListenerWrapper(ElasticsearchRestClientInstrumentationHelperImpl.this);
        }
    }
}

