/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.error.logging;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;

public class Slf4jLoggingInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public Class<?> getAdviceClass() {
        return Slf4jLoggingAdviceService.class;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Logger");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("co.elastic.apm.agent.shaded.slf4j.Logger"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("error").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.lang.String")).and(ElementMatchers.takesArgument(1, ElementMatchers.named("java.lang.Throwable"))));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("logging", "slf4j");
    }

    public static class Slf4jLoggingAdviceService {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void logEnter(@Advice.Argument(value=1) Throwable exception) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            ElasticApmInstrumentation.tracer.getActive().captureException(exception);
        }
    }
}

