/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.concurrent;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public abstract class ExecutorInstrumentation
extends ElasticApmInstrumentation {
    public static final WeakConcurrentSet<Executor> excluded = new WeakConcurrentSet(WeakConcurrentSet.Cleaner.THREAD);
    public static final Set<String> excludedClasses = new HashSet<String>();

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Execut").or(ElementMatchers.nameContains("Loop")).or(ElementMatchers.nameContains("Pool")).or(ElementMatchers.nameContains("Dispatch"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("java.util.concurrent.Executor")).and(ElementMatchers.not(ElementMatchers.named("org.apache.felix.resolver.ResolverImpl$DumbExecutor"))).and(ElementMatchers.not(ElementMatchers.nameStartsWith("com.hazelcast"))).and(ElementMatchers.not(CustomElementMatchers.isProxy()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("concurrent", "executor");
    }

    public static boolean isExcluded(@Advice.This Executor executor) {
        return excluded.contains(executor) || excludedClasses.contains(executor.getClass().getName());
    }

    static {
        excludedClasses.add("org.glassfish.enterprise.concurrent.internal.ManagedThreadPoolExecutor");
        excludedClasses.add("org.apache.tomcat.util.threads.ThreadPoolExecutor");
        excludedClasses.add("com.pilotfish.eip.server.ntm.pool.NTMThreadPool");
    }

    public static class ExecutorCallableInstrumentation
    extends ExecutorInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onSubmit(@Advice.This Executor thiz, @Advice.Argument(value=0, readOnly=false) @Nullable Callable<?> callable, @Advice.Local(value="original") Callable original) {
            TraceContextHolder<?> active = ExecutorInstrumentation.getActive();
            if (active != null && callable != null && !ExecutorCallableInstrumentation.isExcluded(thiz) && tracer != null && tracer.isWrappingAllowedOnThread()) {
                original = callable;
                active.setDiscard(false);
                callable = active.withActive(callable);
                tracer.avoidWrappingOnThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Exception.class, repeatOn=Advice.OnNonDefaultValue.class)
        public static boolean onError(@Advice.This Executor thiz, @Nullable @Advice.Thrown Exception exception, @Nullable @Advice.Argument(value=0, readOnly=false) Callable callable, @Advice.Local(value="original") Callable original) {
            try {
                if (exception instanceof ClassCastException || exception instanceof IllegalArgumentException) {
                    callable = original;
                    boolean bl = excluded.add(thiz);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (tracer != null) {
                    tracer.allowWrappingOnThread();
                }
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("submit").and(ElementMatchers.returns(Future.class)).and(ElementMatchers.takesArguments(Callable.class));
        }
    }

    public static class ExecutorRunnableInstrumentation
    extends ExecutorInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onExecute(@Advice.This Executor thiz, @Advice.Argument(value=0, readOnly=false) @Nullable Runnable runnable, @Advice.Local(value="original") Runnable original) {
            TraceContextHolder<?> active = ExecutorInstrumentation.getActive();
            if (active != null && runnable != null && !ExecutorRunnableInstrumentation.isExcluded(thiz) && tracer != null && tracer.isWrappingAllowedOnThread()) {
                original = runnable;
                active.setDiscard(false);
                runnable = active.withActive(runnable);
                tracer.avoidWrappingOnThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Exception.class, repeatOn=Advice.OnNonDefaultValue.class)
        public static boolean onError(@Advice.This Executor thiz, @Nullable @Advice.Thrown Exception exception, @Nullable @Advice.Argument(value=0, readOnly=false) Runnable runnable, @Advice.Local(value="original") @Nullable Runnable original) {
            try {
                if (original != null && (exception instanceof ClassCastException || exception instanceof IllegalArgumentException)) {
                    runnable = original;
                    boolean bl = excluded.add(thiz);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (tracer != null) {
                    tracer.allowWrappingOnThread();
                }
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("execute").and(ElementMatchers.returns(Void.TYPE)).and(ElementMatchers.takesArguments(Runnable.class)).or(ElementMatchers.named("submit").and(ElementMatchers.returns(Future.class)).and(ElementMatchers.takesArguments(Runnable.class))).or(ElementMatchers.named("submit").and(ElementMatchers.returns(Future.class)).and(ElementMatchers.takesArguments(Runnable.class, Object.class)));
        }
    }
}

