/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.bci.bytebuddy.MethodHierarchyMatcher;
import co.elastic.apm.agent.matcher.AnnotationMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.annotation.AnnotationSource;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.Version;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;

public class CustomElementMatchers {
    private static final Logger logger = LoggerFactory.getLogger(CustomElementMatchers.class);

    public static ElementMatcher.Junction<NamedElement> isInAnyPackage(Collection<String> includedPackages, ElementMatcher.Junction<NamedElement> defaultIfEmpty) {
        if (includedPackages.isEmpty()) {
            return defaultIfEmpty;
        }
        ElementMatcher.Junction<NamedElement> matcher = ElementMatchers.none();
        for (String applicationPackage : includedPackages) {
            matcher = matcher.or(ElementMatchers.nameStartsWith(applicationPackage));
        }
        return matcher;
    }

    public static ElementMatcher.Junction<ClassLoader> classLoaderCanLoadClass(final String className) {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){
            private final boolean loadableByBootstrapClassLoader;
            private WeakConcurrentMap<ClassLoader, Boolean> cache;
            {
                this.loadableByBootstrapClassLoader = CustomElementMatchers.canLoadClass(null, className);
                this.cache = new WeakConcurrentMap.WithInlinedExpunction<ClassLoader, Boolean>();
            }

            @Override
            public boolean matches(@Nullable ClassLoader target) {
                if (target == null) {
                    return this.loadableByBootstrapClassLoader;
                }
                Boolean result = this.cache.get(target);
                if (result == null) {
                    result = CustomElementMatchers.canLoadClass(target, className);
                    this.cache.put(target, result);
                }
                return result;
            }
        };
    }

    private static boolean canLoadClass(@Nullable ClassLoader target, String className) {
        boolean result;
        try {
            String classResource = className.replace('.', '/') + ".class";
            URL resource = target == null ? Object.class.getResource("/" + classResource) : target.getResource(classResource);
            boolean bl = result = resource != null;
            if (logger.isDebugEnabled()) {
                String classLoaderName = target == null ? "Bootstrap ClassLoader" : target.getClass().getName();
                String codeSourceString = "";
                if (resource != null) {
                    codeSourceString = " from " + resource;
                }
                logger.debug("{} was loaded by {}{}", className, classLoaderName, codeSourceString);
            }
        }
        catch (Exception ignore) {
            result = false;
        }
        return result;
    }

    public static ElementMatcher.Junction<ProtectionDomain> implementationVersionLte(final String version) {
        return new ElementMatcher.Junction.AbstractBase<ProtectionDomain>(){

            @Override
            public boolean matches(@Nullable ProtectionDomain protectionDomain) {
                try {
                    Version pdVersion = CustomElementMatchers.readImplementationVersionFromManifest(protectionDomain);
                    Version limitVersion = new Version(version);
                    if (pdVersion != null) {
                        return pdVersion.compareTo(limitVersion) <= 0;
                    }
                }
                catch (Exception e) {
                    logger.info("Cannot read implementation version based on ProtectionDomain. This should not affect you agent's functionality. Failed with message: " + e.getMessage());
                    logger.debug("Implementation version parsing error: " + protectionDomain, e);
                }
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Version readImplementationVersionFromManifest(@Nullable ProtectionDomain protectionDomain) throws IOException, URISyntaxException {
        Version version = null;
        ZipFile jarFile = null;
        try {
            if (protectionDomain != null) {
                String implementationVersion;
                URLConnection urlConnection;
                Manifest manifest;
                URL jarUrl;
                CodeSource codeSource = protectionDomain.getCodeSource();
                if (codeSource != null && (jarUrl = codeSource.getLocation()) != null && (manifest = ((JarFile)(jarFile = (urlConnection = jarUrl.openConnection()) instanceof JarURLConnection ? ((JarURLConnection)urlConnection).getJarFile() : new JarFile(new File(jarUrl.toURI())))).getManifest()) != null && (implementationVersion = manifest.getMainAttributes().getValue("Implementation-Version")) != null) {
                    version = new Version(implementationVersion);
                }
            } else {
                logger.info("Cannot read implementation version - got null ProtectionDomain");
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    logger.error("Error closing JarFile", e);
                }
            }
        }
        return version;
    }

    public static MethodHierarchyMatcher overridesOrImplementsMethodThat(ElementMatcher<? super MethodDescription> methodElementMatcher) {
        return new MethodHierarchyMatcher(methodElementMatcher);
    }

    public static ElementMatcher.Junction<NamedElement> matches(final WildcardMatcher matcher) {
        return new ElementMatcher.Junction.AbstractBase<NamedElement>(){

            @Override
            public boolean matches(NamedElement target) {
                return matcher.matches(target.getActualName());
            }

            public String toString() {
                return "matches(" + matcher + ")";
            }
        };
    }

    public static ElementMatcher.Junction<AnnotationSource> annotationMatches(String annotationWildcard) {
        return AnnotationMatcher.annotationMatcher(annotationWildcard);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> isProxy() {
        return ElementMatchers.nameContains("$Proxy").or(ElementMatchers.nameContains("$$"));
    }
}

