/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.ClassLoaderNameMatcher;
import co.elastic.apm.agent.bci.bytebuddy.ErrorLoggingListener;
import co.elastic.apm.agent.bci.bytebuddy.FailSafeDeclaredMethodsCompiler;
import co.elastic.apm.agent.bci.bytebuddy.MatcherTimer;
import co.elastic.apm.agent.bci.bytebuddy.MinimumClassFileVersionValidator;
import co.elastic.apm.agent.bci.bytebuddy.RootPackageCustomLocator;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.SoftlyReferencingTypePoolCache;
import co.elastic.apm.agent.bci.methodmatching.MethodMatcher;
import co.elastic.apm.agent.bci.methodmatching.TraceMethodInstrumentation;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.ElasticApmTracerBuilder;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.ByteBuddy;
import co.elastic.apm.agent.shaded.bytebuddy.agent.builder.AgentBuilder;
import co.elastic.apm.agent.shaded.bytebuddy.agent.builder.ResettableClassFileTransformer;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.dynamic.ClassFileLocator;
import co.elastic.apm.agent.shaded.bytebuddy.dynamic.DynamicType;
import co.elastic.apm.agent.shaded.bytebuddy.dynamic.scaffold.TypeValidation;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.bytebuddy.pool.TypePool;
import co.elastic.apm.agent.shaded.bytebuddy.utility.JavaModule;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ElasticApmAgent {
    private static final ConcurrentMap<String, MatcherTimer> matcherTimers = new ConcurrentHashMap<String, MatcherTimer>();
    @Nullable
    private static Instrumentation instrumentation;
    @Nullable
    private static ResettableClassFileTransformer resettableClassFileTransformer;
    @Nullable
    private static File agentJarFile;

    public static void initialize(String agentArguments, Instrumentation instrumentation, File agentJarFile) {
        ElasticApmAgent.agentJarFile = agentJarFile;
        ElasticApmAgent.initInstrumentation(new ElasticApmTracerBuilder(agentArguments).build(), instrumentation);
    }

    public static void initInstrumentation(ElasticApmTracer tracer, Instrumentation instrumentation) {
        ElasticApmAgent.initInstrumentation(tracer, instrumentation, ElasticApmAgent.loadInstrumentations(tracer));
    }

    @Nonnull
    private static Iterable<ElasticApmInstrumentation> loadInstrumentations(ElasticApmTracer tracer) {
        List<ElasticApmInstrumentation> instrumentations = DependencyInjectingServiceLoader.load(ElasticApmInstrumentation.class, tracer);
        for (MethodMatcher traceMethod : tracer.getConfig(CoreConfiguration.class).getTraceMethods()) {
            instrumentations.add(new TraceMethodInstrumentation(tracer, traceMethod));
        }
        return instrumentations;
    }

    public static void initInstrumentation(final ElasticApmTracer tracer, Instrumentation instrumentation, Iterable<ElasticApmInstrumentation> instrumentations) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                tracer.stop();
                matcherTimers.clear();
            }
        });
        matcherTimers.clear();
        Logger logger = LoggerFactory.getLogger(ElasticApmAgent.class);
        if (ElasticApmAgent.instrumentation != null) {
            logger.warn("Instrumentation has already been initialized");
            return;
        }
        ElasticApmInstrumentation.staticInit(tracer);
        CoreConfiguration coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        ElasticApmAgent.instrumentation = instrumentation;
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(logger.isDebugEnabled())).with(FailSafeDeclaredMethodsCompiler.INSTANCE);
        AgentBuilder agentBuilder = ElasticApmAgent.getAgentBuilder(byteBuddy, coreConfiguration, logger);
        int numberOfAdvices = 0;
        for (ElasticApmInstrumentation advice : instrumentations) {
            if (!ElasticApmAgent.isIncluded(advice, coreConfiguration)) continue;
            ++numberOfAdvices;
            agentBuilder = ElasticApmAgent.applyAdvice(tracer, agentBuilder, advice);
        }
        logger.debug("Applied {} advices", (Object)numberOfAdvices);
        resettableClassFileTransformer = agentBuilder.installOn(ElasticApmAgent.instrumentation);
    }

    private static boolean isIncluded(ElasticApmInstrumentation advice, CoreConfiguration coreConfiguration) {
        Collection<String> disabledInstrumentations = coreConfiguration.getDisabledInstrumentations();
        return !ElasticApmAgent.isGroupDisabled(disabledInstrumentations, advice.getInstrumentationGroupNames()) && ElasticApmAgent.isInstrumentationEnabled(advice, coreConfiguration);
    }

    private static boolean isGroupDisabled(Collection<String> disabledInstrumentations, Collection<String> instrumentationGroupNames) {
        for (String instrumentationGroupName : instrumentationGroupNames) {
            if (!disabledInstrumentations.contains(instrumentationGroupName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInstrumentationEnabled(ElasticApmInstrumentation advice, CoreConfiguration coreConfiguration) {
        return advice.includeWhenInstrumentationIsDisabled() || coreConfiguration.isInstrument();
    }

    private static AgentBuilder applyAdvice(ElasticApmTracer tracer, AgentBuilder agentBuilder, final ElasticApmInstrumentation instrumentation) {
        final Logger logger = LoggerFactory.getLogger(ElasticApmAgent.class);
        logger.debug("Applying instrumentation {}", (Object)instrumentation.getClass().getName());
        final boolean classLoadingMatchingPreFilter = tracer.getConfig(CoreConfiguration.class).isClassLoadingMatchingPreFilter();
        final boolean typeMatchingWithNamePreFilter = tracer.getConfig(CoreConfiguration.class).isTypeMatchingWithNamePreFilter();
        final ElementMatcher.Junction<ClassLoader> classLoaderMatcher = instrumentation.getClassLoaderMatcher();
        final ElementMatcher<? super NamedElement> typeMatcherPreFilter = instrumentation.getTypeMatcherPreFilter();
        final ElementMatcher.Junction<ProtectionDomain> versionPostFilter = instrumentation.getImplementationVersionPostFilter();
        final ElementMatcher<? super TypeDescription> typeMatcher = instrumentation.getTypeMatcher();
        ElementMatcher<? super MethodDescription> methodMatcher = instrumentation.getMethodMatcher();
        return agentBuilder.type(new AgentBuilder.RawMatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                long start = System.nanoTime();
                try {
                    boolean typeMatches;
                    if (classLoadingMatchingPreFilter && !classLoaderMatcher.matches(classLoader)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (typeMatchingWithNamePreFilter && !typeMatcherPreFilter.matches(typeDescription)) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        typeMatches = typeMatcher.matches(typeDescription) && versionPostFilter.matches(protectionDomain);
                    }
                    catch (Exception ignored) {
                        typeMatches = false;
                    }
                    if (typeMatches) {
                        logger.debug("Type match for instrumentation {}: {} matches {}", instrumentation.getClass().getSimpleName(), typeMatcher, typeDescription);
                        try {
                            instrumentation.onTypeMatch(typeDescription, classLoader, protectionDomain, classBeingRedefined);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), e);
                        }
                        if (logger.isTraceEnabled()) {
                            ElasticApmAgent.logClassLoaderHierarchy(classLoader, logger, instrumentation);
                        }
                    }
                    boolean bl = typeMatches;
                    return bl;
                }
                finally {
                    ElasticApmAgent.getOrCreateTimer(instrumentation.getClass()).addTypeMatchingDuration(System.nanoTime() - start);
                }
            }
        }).transform(ElasticApmAgent.getTransformer(tracer, instrumentation, logger, methodMatcher)).transform(new AgentBuilder.Transformer(){

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit(MinimumClassFileVersionValidator.INSTANCE);
            }
        });
    }

    private static AgentBuilder.Transformer.ForAdvice getTransformer(ElasticApmTracer tracer, final ElasticApmInstrumentation instrumentation, final Logger logger, final ElementMatcher<? super MethodDescription> methodMatcher) {
        Advice.WithCustomMapping withCustomMapping = Advice.withCustomMapping().bind(new SimpleMethodSignatureOffsetMappingFactory()).bind(new AnnotationValueOffsetMappingFactory());
        Advice.OffsetMapping.Factory<?> offsetMapping = instrumentation.getOffsetMapping();
        if (offsetMapping != null) {
            withCustomMapping = withCustomMapping.bind(offsetMapping);
        }
        return new AgentBuilder.Transformer.ForAdvice(withCustomMapping).advice((ElementMatcher<? super MethodDescription>)new ElementMatcher<MethodDescription>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean matches(MethodDescription target) {
                long start = System.nanoTime();
                try {
                    boolean matches;
                    try {
                        matches = methodMatcher.matches(target);
                    }
                    catch (Exception ignored) {
                        matches = false;
                    }
                    if (matches) {
                        logger.debug("Method match for instrumentation {}: {} matches {}", instrumentation.getClass().getSimpleName(), methodMatcher, target);
                    }
                    boolean bl = matches;
                    return bl;
                }
                finally {
                    ElasticApmAgent.getOrCreateTimer(instrumentation.getClass()).addMethodMatchingDuration(System.nanoTime() - start);
                }
            }
        }, instrumentation.getAdviceClass().getName()).include(ClassLoader.getSystemClassLoader()).withExceptionHandler(Advice.ExceptionHandler.Default.PRINTING);
    }

    private static MatcherTimer getOrCreateTimer(Class<? extends ElasticApmInstrumentation> adviceClass) {
        String name = adviceClass.getName();
        MatcherTimer timer = (MatcherTimer)matcherTimers.get(name);
        if (timer == null) {
            matcherTimers.putIfAbsent(name, new MatcherTimer(name));
            return (MatcherTimer)matcherTimers.get(name);
        }
        return timer;
    }

    static long getTotalMatcherTime() {
        long totalTime = 0L;
        for (MatcherTimer value : matcherTimers.values()) {
            totalTime += value.getTotalTime();
        }
        return totalTime;
    }

    static Collection<MatcherTimer> getMatcherTimers() {
        return matcherTimers.values();
    }

    private static void logClassLoaderHierarchy(@Nullable ClassLoader classLoader, Logger logger, ElasticApmInstrumentation advice) {
        logger.trace("Advice {} is loaded by {}", (Object)advice.getClass().getName(), (Object)advice.getClass().getClassLoader());
        if (classLoader != null) {
            boolean canLoadAgent = false;
            try {
                classLoader.loadClass(advice.getClass().getName());
                canLoadAgent = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            logger.trace("{} can load advice ({}): {}", classLoader, advice.getClass().getName(), canLoadAgent);
            ElasticApmAgent.logClassLoaderHierarchy(classLoader.getParent(), logger, advice);
        } else {
            logger.trace("bootstrap classloader");
        }
    }

    public static synchronized void reset() {
        if (resettableClassFileTransformer == null || instrumentation == null) {
            throw new IllegalStateException("Reset was called before init");
        }
        resettableClassFileTransformer.reset(instrumentation, AgentBuilder.RedefinitionStrategy.RETRANSFORMATION);
        instrumentation = null;
        resettableClassFileTransformer = null;
    }

    private static AgentBuilder getAgentBuilder(ByteBuddy byteBuddy, CoreConfiguration coreConfiguration, Logger logger) {
        final List<WildcardMatcher> classesExcludedFromInstrumentation = coreConfiguration.getClassesExcludedFromInstrumentation();
        AgentBuilder.LocationStrategy locationStrategy = AgentBuilder.LocationStrategy.ForClassLoader.WEAK;
        if (agentJarFile != null) {
            try {
                locationStrategy = locationStrategy.withFallbackTo(ClassFileLocator.ForJarFile.of(agentJarFile), new RootPackageCustomLocator("java.", ClassFileLocator.ForClassLoader.ofBootLoader()));
            }
            catch (IOException e) {
                logger.warn("Failed to add ClassFileLocator for the agent jar. Some instrumentations may not work", e);
            }
        }
        return ((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)new AgentBuilder.Default(byteBuddy).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with(locationStrategy).with(new ErrorLoggingListener()).with(coreConfiguration.isTypePoolCacheEnabled() ? new SoftlyReferencingTypePoolCache(TypePool.Default.ReaderMode.FAST, 1, ClassLoaderNameMatcher.isReflectionClassLoader()) : AgentBuilder.PoolStrategy.Default.FAST).ignore(ElementMatchers.any(), ClassLoaderNameMatcher.isReflectionClassLoader()).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithName("org.codehaus.groovy.runtime.callsite.CallSiteClassLoader"))).or(ElementMatchers.nameStartsWith("java.").and(ElementMatchers.not(ElementMatchers.nameEndsWith("URLConnection").or(ElementMatchers.nameStartsWith("java.util.concurrent.")))))).or(ElementMatchers.nameStartsWith("com.sun.").and(ElementMatchers.not(ElementMatchers.nameStartsWith("com.sun.faces.").or(ElementMatchers.nameEndsWith("URLConnection")))))).or(ElementMatchers.nameStartsWith("sun").and(ElementMatchers.not(ElementMatchers.nameEndsWith("URLConnection"))))).or(ElementMatchers.nameStartsWith("co.elastic.apm.agent.shaded"))).or(ElementMatchers.nameStartsWith("org.aspectj."))).or(ElementMatchers.nameStartsWith("org.groovy."))).or(ElementMatchers.nameStartsWith("com.p6spy."))).or(ElementMatchers.nameStartsWith("co.elastic.apm.agent.shaded.bytebuddy."))).or(ElementMatchers.nameStartsWith("co.elastic.apm.agent.shaded.stagemonitor."))).or(ElementMatchers.nameContains("javassist"))).or(ElementMatchers.nameContains(".asm."))).or((ElementMatcher<TypeDescription>)new ElementMatcher.Junction.AbstractBase<TypeDescription>(){

            @Override
            public boolean matches(TypeDescription target) {
                return WildcardMatcher.anyMatch(classesExcludedFromInstrumentation, target.getName()) != null;
            }
        })).disableClassFormatChanges();
    }

    @Nullable
    public static String getAgentHome() {
        return agentJarFile == null ? null : agentJarFile.getParent();
    }
}

