/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.TxConstants;
import co.cask.tephra.distributed.AbstractClientProvider;
import co.cask.tephra.distributed.CloseableThriftClient;
import co.cask.tephra.distributed.ElasticPool;
import co.cask.tephra.distributed.TransactionServiceThriftClient;
import com.google.common.base.Throwables;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TException;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledClientProvider
extends AbstractClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PooledClientProvider.class);
    private volatile TxClientPool clients;
    private int maxClients;
    private long obtainClientTimeoutMs;

    public PooledClientProvider(Configuration conf, DiscoveryServiceClient discoveryServiceClient) {
        super(conf, discoveryServiceClient);
    }

    private void initializePool() throws TException {
        super.initialize();
        this.maxClients = this.configuration.getInt("data.tx.client.count", 50);
        if (this.maxClients < 1) {
            LOG.warn("Configuration of data.tx.client.count is invalid: value is " + this.maxClients + " but must be at least 1. " + "Using 1 as a fallback. ");
            this.maxClients = 1;
        }
        this.obtainClientTimeoutMs = this.configuration.getLong("data.tx.client.obtain.timeout", TxConstants.Service.DEFAULT_DATA_TX_CLIENT_OBTAIN_TIMEOUT_MS);
        if (this.obtainClientTimeoutMs < 0L) {
            LOG.warn("Configuration of data.tx.client.count is invalid: value is " + this.obtainClientTimeoutMs + " but must be at least 0. " + "Using 0 as a fallback. ");
            this.obtainClientTimeoutMs = 0L;
        }
        this.clients = new TxClientPool(this.maxClients);
    }

    @Override
    public CloseableThriftClient getCloseableClient() throws TException, TimeoutException, InterruptedException {
        TransactionServiceThriftClient client = (TransactionServiceThriftClient)this.getClientPool().obtain(this.obtainClientTimeoutMs, TimeUnit.MILLISECONDS);
        return new CloseableThriftClient(this, client);
    }

    @Override
    public void returnClient(TransactionServiceThriftClient client) {
        this.getClientPool().release(client);
    }

    public String toString() {
        return "Elastic pool of size " + this.maxClients + ", with timeout (in milliseconds): " + this.obtainClientTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxClientPool getClientPool() {
        if (this.clients != null) {
            return this.clients;
        }
        PooledClientProvider pooledClientProvider = this;
        synchronized (pooledClientProvider) {
            if (this.clients == null) {
                try {
                    this.initializePool();
                }
                catch (TException e) {
                    LOG.error("Failed to initialize Tx client provider", (Throwable)e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        return this.clients;
    }

    class TxClientPool
    extends ElasticPool<TransactionServiceThriftClient, TException> {
        TxClientPool(int sizeLimit) {
            super(sizeLimit);
        }

        @Override
        protected TransactionServiceThriftClient create() throws TException {
            return PooledClientProvider.this.newClient();
        }

        @Override
        protected boolean recycle(TransactionServiceThriftClient client) {
            if (!client.isValid()) {
                client.close();
                return false;
            }
            return true;
        }
    }
}

