/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.resource;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.resource.DownloadResult;
import cn.jmessage.api.resource.UploadResult;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClient
extends BaseClient {
    private static Logger LOG = LoggerFactory.getLogger(ResourceClient.class);
    private String resourcePath;
    private String authCode;

    public ResourceClient(String appkey, String masterSecret) {
        this(appkey, masterSecret, null, JMessageConfig.getInstance());
    }

    public ResourceClient(String appkey, String masterSecret, HttpProxy proxy) {
        this(appkey, masterSecret, proxy, JMessageConfig.getInstance());
    }

    public ResourceClient(String appkey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appkey, masterSecret, proxy, config);
        this.resourcePath = (String)config.get("im.resource.path");
        this.authCode = ServiceHelper.getBasicAuthorization((String)appkey, (String)masterSecret);
    }

    public DownloadResult downloadFile(String mediaId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != mediaId ? 1 : 0) != 0, (Object)"mediaId is necessary");
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.resourcePath + "?mediaId=" + mediaId);
        return (DownloadResult)DownloadResult.fromResponse((ResponseWrapper)response, DownloadResult.class);
    }

    public UploadResult uploadFile(String path) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != path ? 1 : 0) != 0, (Object)"filename is necessary");
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            long fileSize = file.length();
            if (fileSize > 0x800000L) {
                throw new IllegalArgumentException("File size should not larger than 8M");
            }
            try {
                String newLine = "\r\n";
                String boundaryPrefix = "--";
                String BOUNDARY = "========7d4a6d158c9";
                URL url = new URL(this._baseUrl + this.resourcePath + "?type=image");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("connection", "Keep-Alive");
                conn.setRequestProperty("Charset", "UTF-8");
                conn.setRequestProperty("Authorization", this.authCode);
                conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(BOUNDARY);
                sb.append("\r\n");
                sb.append("Content-Disposition: form-data;name=\"image\";filename=\"" + path + "\"" + "\r\n");
                sb.append("Content-Type:application/octet-stream");
                sb.append("\r\n");
                sb.append("\r\n");
                ((OutputStream)out).write(sb.toString().getBytes());
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                byte[] bufferOut = new byte[1024];
                int bytes = 0;
                while ((bytes = dataInputStream.read(bufferOut)) != -1) {
                    ((OutputStream)out).write(bufferOut, 0, bytes);
                }
                ((OutputStream)out).write("\r\n".getBytes());
                dataInputStream.close();
                byte[] end_data = ("\r\n--" + BOUNDARY + "--" + "\r\n").getBytes();
                ((OutputStream)out).write(end_data);
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                LOG.debug("Send request - POST " + url);
                int status1 = conn.getResponseCode();
                StringBuffer stringBuffer = new StringBuffer();
                InputStream in = null;
                in = status1 / 100 == 2 ? conn.getInputStream() : conn.getErrorStream();
                if (null != in) {
                    int remaining;
                    InputStreamReader responseContent = new InputStreamReader(in, "UTF-8");
                    char[] quota = new char[1024];
                    while ((remaining = responseContent.read(quota)) > 0) {
                        stringBuffer.append(quota, 0, remaining);
                    }
                }
                ResponseWrapper wrapper = new ResponseWrapper();
                String responseContent1 = stringBuffer.toString();
                wrapper.responseCode = status1;
                wrapper.responseContent = responseContent1;
                String quota1 = conn.getHeaderField("X-Rate-Limit-Limit");
                String remaining1 = conn.getHeaderField("X-Rate-Limit-Remaining");
                String reset = conn.getHeaderField("X-Rate-Limit-Reset");
                wrapper.setRateLimit(quota1, remaining1, reset);
                if (status1 >= 200 && status1 < 300) {
                    LOG.debug("Succeed to get response OK - responseCode:" + status1);
                    LOG.debug("Response Content - " + responseContent1);
                } else {
                    if (status1 < 300 || status1 >= 400) {
                        LOG.warn("Got error response - responseCode:" + status1 + ", responseContent:" + responseContent1);
                        wrapper.setErrorObject();
                        throw new APIRequestException(wrapper);
                    }
                    LOG.warn("Normal response but unexpected - responseCode:" + status1 + ", responseContent:" + responseContent1);
                }
                return (UploadResult)UploadResult.fromResponse((ResponseWrapper)wrapper, UploadResult.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("File name is invalid, please check again");
        }
        return null;
    }
}

